package org.gcube.spatial.data.sdi.engine.impl.gn.extension;

import java.util.HashSet;
import java.util.Set;

import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.model.User.Profile;
import org.gcube.spatial.data.geonetwork.utils.StringUtils;

public class GeoNetworkUtils {

	
	/**
	 * Adds a suffix to groupName if needed
	 * 
	 * @param existing
	 * @param groupName
	 * @return
	 */
	public static Group generateGroup(Set<Group> existing, String groupName, String description, String contactMail){
		Set<String> existingNames=new HashSet<>();
		int maxId=0;
		for(Group g:existing){
			existingNames.add(g.getName());
			if(maxId<g.getId())maxId=g.getId();
		}
		
		String toUseName=clashSafeString(groupName,existingNames);
		
		return new Group(toUseName, description, contactMail, maxId+1);		
	}
	
	
	public static User generateUser(Set<User> existing, Integer passwordLength, String username){
		Set<String> existingNames=new HashSet<>();
		for(User g:existing)existingNames.add(g.getUsername());
		
		String toUseUserName=clashSafeString(username,existingNames);
		
		return new User(0, // NB will be updated when creating it..
				toUseUserName,
				StringUtils.generateRandomString(passwordLength),Profile.RegisteredUser);	
	}
	
		
	public static String clashSafeString(String originalString,Set<String> existingSet) {
		String toReturn=originalString;
		int suffix=1;
		while(existingSet.contains(toReturn)) {
			toReturn=originalString+"_"+suffix;
			suffix++;
		}
		return toReturn;
	}
}
