/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.geonetwork.model.Group;
import org.gcube.spatial.data.geonetwork.model.User;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.ScopeUtils;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoServiceController;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.OutdatedServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceInteractionException;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkClient;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkUtils;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoNetworkController
extends GeoServiceController<GeoNetworkDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkController.class);
    String scopeUserPrefix = LocalConfiguration.getProperty((String)"gn.se.scope.user.prefix");
    String scopePasswordPrefix = LocalConfiguration.getProperty((String)"gn.se.scope.password.prefix");
    String ckanUserPrefix = LocalConfiguration.getProperty((String)"gn.se.ckan.user.prefix");
    String ckanPasswordPrefix = LocalConfiguration.getProperty((String)"gn.se.ckan.password.prefix");
    String managerUserPrefix = LocalConfiguration.getProperty((String)"gn.se.manager.user.prefix");
    String managerPasswordPrefix = LocalConfiguration.getProperty((String)"gn.se.manager.password.prefix");
    String assignedScopePrefix = LocalConfiguration.getProperty((String)"gn.se.assigned.scope.prefix");
    String defaultGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.default.group.prefix");
    String sharedGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.shared.group.prefix");
    String confidentialGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.confidential.group.prefix");
    String contextGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.context.group.prefix");
    String suffixesProperty = LocalConfiguration.getProperty((String)"gn.se.suffixes");
    String priorityProperty = LocalConfiguration.getProperty((String)"gn.se.priority");
    private String suffixes = this.getSEProperty(this.suffixesProperty, true);
    private Integer priority = Integer.parseInt(this.getSEProperty(this.priorityProperty, true));

    public GeoNetworkController(ServiceEndpoint serviceEndpoint) throws InvalidServiceEndpointException {
        super(serviceEndpoint);
    }

    protected GeoNetworkDescriptor getLiveDescriptor() {
        GeoNetworkDescriptor descriptor = new GeoNetworkDescriptor();
        descriptor.setBaseEndpoint(this.baseURL);
        descriptor.setVersion(this.version);
        String currentScopeName = ScopeUtils.getCurrentScopeName();
        String suffix = this.getSuffixByScope(currentScopeName);
        ArrayList<Credentials> availableCredentials = new ArrayList<Credentials>();
        availableCredentials.add(this.adminAccount);
        Credentials context = new Credentials(this.getSEProperty(this.scopeUserPrefix + suffix, true), this.getSEProperty(this.scopePasswordPrefix + suffix, true), AccessType.CONTEXT_USER);
        availableCredentials.add(context);
        Credentials ckan = new Credentials(this.getSEProperty(this.ckanUserPrefix + suffix, true), this.getSEProperty(this.ckanPasswordPrefix + suffix, true), AccessType.CKAN);
        availableCredentials.add(ckan);
        String managerUser = this.getSEProperty(this.managerUserPrefix + suffix, false);
        if (managerUser != null) {
            Credentials manager = new Credentials(managerUser, this.getSEProperty(this.managerPasswordPrefix + suffix, true), AccessType.CONTEXT_MANAGER);
            availableCredentials.add(manager);
        }
        descriptor.setAccessibleCredentials(availableCredentials);
        descriptor.setPriority(this.priority);
        descriptor.setContextGroup(this.getSEProperty(this.contextGroupPrefix + suffix, true));
        descriptor.setSharedGroup(this.getSEProperty(this.sharedGroupPrefix + suffix, true));
        String confidentialGroup = this.getSEProperty(this.confidentialGroupPrefix + suffix, false);
        if (confidentialGroup != null) {
            descriptor.setConfidentialGroup(confidentialGroup);
        }
        descriptor.setDefaultGroup(this.getSEProperty(this.defaultGroupPrefix + suffix, true));
        descriptor.setPublicGroup(LocalConfiguration.getProperty((String)"gn.groups.all"));
        return descriptor;
    }

    protected ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint endpoint) {
        for (ServiceEndpoint.AccessPoint declaredPoint : endpoint.profile().accessPoints().asCollection()) {
            if (!declaredPoint.name().equals(LocalConfiguration.getProperty((String)"gn.se.endpointName"))) continue;
            return declaredPoint;
        }
        return null;
    }

    protected void initServiceEndpoint() throws OutdatedServiceEndpointException, ServiceInteractionException {
        String scopeName = ScopeUtils.getCurrentScopeName();
        String suffix = this.getSuffixByScope(scopeName);
        if (suffix == null) {
            this.insertScopeInfo(ScopeUtils.getCurrentScope());
        }
    }

    private void insertScopeInfo(String scope) throws OutdatedServiceEndpointException, ServiceInteractionException {
        String scopeName = ScopeUtils.getScopeName((String)scope);
        log.info("Creating scope {} configuration for GeoNetwork at {} ", (Object)scopeName, (Object)this.baseURL);
        log.debug("Instantiating client as admin..");
        GeoNetworkClient gnClient = new GeoNetworkClient(this.baseURL, this.version, this.adminAccount.getPassword(), this.adminAccount.getUsername());
        log.debug("Getting Users and groups from instance..");
        Set existingGroups = gnClient.getGroups();
        Set existingUsers = gnClient.getUsers();
        ArrayList<User> sharedGroupExternalUsers = new ArrayList<User>();
        ArrayList externalGroupsToAccess = new ArrayList();
        log.debug("Getting Siblings information from SE..");
        for (String siblingScope : ISUtils.getSiblingsScopesInResource((Resource)this.serviceEndpoint, (String)scope)) {
            for (String username : this.getUserNamesByScope(siblingScope, true, true, false)) {
                sharedGroupExternalUsers.add(UserUtils.getByName((Set)existingUsers, (String)username));
            }
            externalGroupsToAccess.addAll(this.getGroupIDSByScope(siblingScope, true, false, false));
        }
        log.debug("Getting Parents information from SE..");
        for (String parentScope : ScopeUtils.getParentScopes((String)scope)) {
            for (String username : this.getUserNamesByScope(parentScope, true, true, false)) {
                sharedGroupExternalUsers.add(UserUtils.getByName((Set)existingUsers, (String)username));
            }
            externalGroupsToAccess.addAll(this.getGroupIDSByScope(parentScope, true, true, false));
        }
        log.debug("Creating groups..");
        String contactMail = LocalConfiguration.getProperty((String)"gn.contact.mail");
        int passwordLength = Integer.parseInt(LocalConfiguration.getProperty((String)"gn.password.length", (String)"10"));
        Group shared = GeoNetworkUtils.generateGroup((Set)existingGroups, (String)("Shared_" + scopeName), (String)("Shared metadata group for " + scopeName), (String)contactMail);
        shared = gnClient.createGroup(shared);
        Group context = GeoNetworkUtils.generateGroup((Set)existingGroups, (String)("Context_" + scopeName), (String)("Context metadata group for " + scopeName), (String)contactMail);
        context = gnClient.createGroup(context);
        Group confidential = GeoNetworkUtils.generateGroup((Set)existingGroups, (String)("Confidential_" + scopeName), (String)("Confidential metadata group for " + scopeName), (String)contactMail);
        confidential = gnClient.createGroup(context);
        log.debug("Giving access to shared group from external scopes..");
        for (User toUpdate : sharedGroupExternalUsers) {
            gnClient.editUser(toUpdate, Collections.singleton(shared.getId()));
        }
        log.debug("Creating users..");
        User ckan = GeoNetworkUtils.generateUser((Set)existingUsers, (Integer)passwordLength, (String)("CKAN_" + scopeName));
        ckan = gnClient.createUsers(ckan, Arrays.asList(shared.getId(), context.getId()));
        User ctx = GeoNetworkUtils.generateUser((Set)existingUsers, (Integer)passwordLength, (String)("Ctx_" + scopeName));
        ArrayList ctxUserAccessibleGroups = new ArrayList();
        ctxUserAccessibleGroups.addAll(externalGroupsToAccess);
        ctxUserAccessibleGroups.add(shared.getId());
        ctxUserAccessibleGroups.add(context.getId());
        ctx = gnClient.createUsers(ctx, ctxUserAccessibleGroups);
        User manager = GeoNetworkUtils.generateUser((Set)existingUsers, (Integer)passwordLength, (String)("Mng_" + scopeName));
        ctxUserAccessibleGroups.add(confidential.getId());
        log.debug("Inserting configuration in Service Endpoint");
        String generatedSuffix = GeoNetworkController.generateSuffix((String)this.suffixes);
        ArrayList<ServiceEndpoint.Property> toUpdateProperties = new ArrayList<ServiceEndpoint.Property>();
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.assignedScopePrefix + generatedSuffix, scopeName));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.scopeUserPrefix + generatedSuffix, ctx.getUsername()));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.scopePasswordPrefix + generatedSuffix, ctx.getPassword()).encrypted(true));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.ckanUserPrefix + generatedSuffix, ckan.getUsername()));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.ckanPasswordPrefix + generatedSuffix, ckan.getPassword()).encrypted(true));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.managerUserPrefix + generatedSuffix, manager.getUsername()));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.managerPasswordPrefix + generatedSuffix, manager.getPassword()).encrypted(true));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.sharedGroupPrefix + generatedSuffix, shared.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.defaultGroupPrefix + generatedSuffix, shared.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.confidentialGroupPrefix + generatedSuffix, confidential.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.contextGroupPrefix + generatedSuffix, context.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(this.suffixesProperty, this.suffixes + "," + generatedSuffix));
        this.accessPoint.properties().addAll(toUpdateProperties);
        throw new OutdatedServiceEndpointException("Created scope configuration for " + scopeName);
    }

    private String getSuffixByScope(String scopeName) {
        log.debug("looking for scope {} suffix. Available suffixes are : {} ", (Object)scopeName, (Object)this.suffixes);
        for (String suff : this.suffixes.split(",")) {
            if (!this.getSEProperty(this.assignedScopePrefix + suff, true).equals(scopeName)) continue;
            return suff;
        }
        return null;
    }

    private static String generateSuffix(String existingSuffixes) {
        log.debug("Generating suffix, existing are : " + existingSuffixes);
        String[] suffixArray = existingSuffixes.split(",");
        int maxIndex = 0;
        for (String suff : suffixArray) {
            try {
                int actual = Integer.parseInt(suff);
                if (actual <= maxIndex) continue;
                maxIndex = actual;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String generated = maxIndex + 1 + "";
        log.debug("Generated suffix is : " + generated);
        return generated;
    }

    private HashSet<String> getUserNamesByScope(String scope, boolean getContext, boolean getManager, boolean getCKAN) {
        HashSet<String> toReturn = new HashSet<String>();
        String scopeName = ScopeUtils.getScopeName((String)scope);
        String scopeSuffix = this.getSuffixByScope(scopeName);
        if (scopeSuffix != null) {
            String scopeManagerUserName;
            if (getContext) {
                toReturn.add(this.getSEProperty(this.scopeUserPrefix + scopeSuffix, true));
            }
            if (getManager && (scopeManagerUserName = this.getSEProperty(this.managerUserPrefix + scopeSuffix, false)) != null) {
                toReturn.add(scopeManagerUserName);
            }
            if (getCKAN) {
                toReturn.add(this.getSEProperty(this.ckanUserPrefix + scopeSuffix, true));
            }
        }
        return toReturn;
    }

    private HashSet<Integer> getGroupIDSByScope(String scope, boolean getShared, boolean getContext, boolean getConfidential) {
        HashSet<Integer> toReturn = new HashSet<Integer>();
        String scopeName = ScopeUtils.getScopeName((String)scope);
        String scopeSuffix = this.getSuffixByScope(scopeName);
        if (scopeSuffix != null) {
            String confidentialGroupName;
            if (getShared) {
                toReturn.add(Integer.parseInt(this.getSEProperty(this.sharedGroupPrefix + scopeSuffix, true)));
            }
            if (getContext) {
                toReturn.add(Integer.parseInt(this.getSEProperty(this.contextGroupPrefix + scopeSuffix, true)));
            }
            if (getConfidential && (confidentialGroupName = this.getSEProperty(this.confidentialGroupPrefix + scopeSuffix, true)) != null) {
                toReturn.add(Integer.parseInt(confidentialGroupName));
            }
        }
        return toReturn;
    }
}

