/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Base64;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);

    public static boolean isSameHost(String toTestHost, String toLookForHost) throws UnknownHostException {
        log.debug("Checking same hosts {},{}", (Object)toTestHost, (Object)toLookForHost);
        if (toTestHost.equalsIgnoreCase(toLookForHost)) {
            return true;
        }
        InetAddress[] toTestHostIPs = InetAddress.getAllByName(toTestHost);
        InetAddress[] toLookForHostIPs = InetAddress.getAllByName(toLookForHost);
        log.debug("Checking IPs. ToTestIPs {}, ToLookForIPs {} ", (Object)toTestHostIPs, (Object)toLookForHostIPs);
        InetAddress[] inetAddressArray = toTestHostIPs;
        int n = toTestHostIPs.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress toTestIP = inetAddressArray[n2];
            InetAddress[] inetAddressArray2 = toLookForHostIPs;
            int n3 = toLookForHostIPs.length;
            int n4 = 0;
            while (n4 < n3) {
                InetAddress toLookForIP = inetAddressArray2[n4];
                if (toTestIP.equals(toLookForIP)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        log.debug("HOSTS are different.");
        return false;
    }

    public static String getHostByURL(String url) {
        try {
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            log.debug("Passed url {} is invalid. Assuming it's an hostname.");
            return url;
        }
    }

    public static final String getHost(String endpoint) throws MalformedURLException {
        log.debug("Get host from endpoint {} ", (Object)endpoint);
        if (endpoint.startsWith("http")) {
            log.debug("Endpoint seems url..");
            return NetUtils.getHostByURL((String)endpoint);
        }
        return endpoint;
    }

    public static boolean isUp(String url) throws IOException {
        String finalUrl = NetUtils.resolveRedirects((String)url);
        log.debug("Checking {} availability .. ", (Object)finalUrl);
        URL urlObj = new URL(finalUrl);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        int status = connection.getResponseCode();
        log.trace("HTTP Status response code for {} is {} ", (Object)finalUrl, (Object)status);
        return status >= 200 && status < 300;
    }

    public static String resolveRedirects(String url) throws IOException {
        log.debug("Resolving redirect for url {} ", (Object)url);
        URL urlObj = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)urlObj.openConnection();
        int status = connection.getResponseCode();
        if (status >= 300 && status < 400) {
            String newUrl = connection.getHeaderField("Location");
            log.debug("Following redirect from {} to {} ", (Object)url, (Object)newUrl);
            return NetUtils.resolveRedirects((String)newUrl);
        }
        return url;
    }

    public static void makeAuthorizedCall(String host, String path, String user, String password) throws IOException {
        String urlString = String.format("https://%s/%s", host, path);
        NetUtils.makeAuthorizedCall((String)urlString, (String)user, (String)password);
    }

    public static void makeAuthorizedCall(String urlString, String user, String password) throws IOException {
        log.debug("Connecting to {} ", (Object)urlString);
        URL url = new URL(urlString);
        URLConnection uc = url.openConnection();
        String userpass = String.valueOf(user) + ":" + password;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encode(userpass.getBytes()));
        uc.setRequestProperty("Authorization", basicAuth);
        uc.setRequestProperty("gcube-token", SecurityTokenProvider.instance.get());
        InputStream in = uc.getInputStream();
    }
}

