/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.spatial.data.sdi.engine.GISManager;
import org.gcube.spatial.data.sdi.engine.GeoNetworkManager;
import org.gcube.spatial.data.sdi.engine.SDIManager;
import org.gcube.spatial.data.sdi.engine.ThreddsManager;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceRegistrationException;
import org.gcube.spatial.data.sdi.model.ScopeConfiguration;
import org.gcube.spatial.data.sdi.model.health.HealthReport;
import org.gcube.spatial.data.sdi.model.health.Level;
import org.gcube.spatial.data.sdi.model.health.ServiceHealthReport;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SDIManagerImpl
implements SDIManager {
    private static final Logger log = LoggerFactory.getLogger(SDIManagerImpl.class);
    GeoNetworkManager geonetworkManager;
    ThreddsManager threddsManager;
    GISManager gisManager;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type;

    @Inject
    public SDIManagerImpl(GeoNetworkManager geonetworkManager, ThreddsManager threddsManager, GISManager gisManager) {
        this.geonetworkManager = geonetworkManager;
        this.threddsManager = threddsManager;
        this.gisManager = gisManager;
    }

    public ScopeConfiguration getContextConfiguration() {
        ScopeConfiguration toReturn = new ScopeConfiguration();
        toReturn.setContextName(ScopeUtils.getCurrentScopeName());
        try {
            toReturn.setGeonetworkConfiguration(this.geonetworkManager.getSuggestedInstances());
        }
        catch (Exception e) {
            log.warn("Scope is not well configured. Missing GeoNetwork. ", (Throwable)e);
        }
        try {
            toReturn.setThreddsConfiguration(this.threddsManager.getSuggestedInstances());
        }
        catch (Exception e) {
            log.warn("THREDDS not found in current scope {} ", (Object)ScopeUtils.getCurrentScope());
        }
        try {
            toReturn.setGeoserverClusterConfiguration(this.gisManager.getSuggestedInstances());
        }
        catch (Exception e) {
            log.warn("GeoServer not found in current scope {} ", (Object)ScopeUtils.getCurrentScope());
        }
        return toReturn;
    }

    public String toString() {
        return super.toString();
    }

    public HealthReport getHealthReport() {
        HealthReport report = new HealthReport();
        report.setContext(ScopeUtils.getCurrentScope());
        ServiceHealthReport threddsReport = this.threddsManager.getHealthReport();
        report.setThredds(threddsReport);
        ServiceHealthReport gnReport = this.geonetworkManager.getHealthReport();
        report.setGeonetwork(gnReport);
        ServiceHealthReport gsReport = this.gisManager.getHealthReport();
        report.setGeoserverCluster(gsReport);
        Level overall = Level.OK;
        if (threddsReport.getOverallStatus().equals((Object)Level.ERROR) || gnReport.getOverallStatus().equals((Object)Level.ERROR) || gsReport.getOverallStatus().equals((Object)Level.ERROR)) {
            overall = Level.ERROR;
        } else if (threddsReport.getOverallStatus().equals((Object)Level.WARNING) || gnReport.getOverallStatus().equals((Object)Level.WARNING) || gsReport.getOverallStatus().equals((Object)Level.WARNING)) {
            overall = Level.WARNING;
        }
        report.setOverallStatus(overall);
        log.debug("Returning report : {} ", (Object)report);
        return report;
    }

    /*
     * Exception decompiling
     */
    public String registerService(ServiceDefinition definition) throws ServiceRegistrationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String importService(String sourceToken, String host, ServiceDefinition.Type expectedType) throws ServiceRegistrationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public GeoNetworkManager getGeoNetworkManager() {
        return this.geonetworkManager;
    }

    public GISManager getGeoServerManager() {
        return this.gisManager;
    }

    public ThreddsManager getThreddsManager() {
        return this.threddsManager;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type() {
        if ($SWITCH_TABLE$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type != null) {
            return $SWITCH_TABLE$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type;
        }
        int[] nArray = new int[ServiceDefinition.Type.values().length];
        try {
            nArray[ServiceDefinition.Type.GEONETWORK.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ServiceDefinition.Type.GEOSERVER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ServiceDefinition.Type.THREDDS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$spatial$data$sdi$model$services$ServiceDefinition$Type = nArray;
        return nArray;
    }
}

