/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.gn.extension;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gcube.spatial.data.sdi.engine.impl.faults.gn.MetadataNotFoundException;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkClient;
import org.gcube.spatial.data.sdi.model.gn.Group;
import org.gcube.spatial.data.sdi.model.gn.User;
import org.gcube.spatial.data.sdi.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoNetworkUtils {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkUtils.class);

    public static Group generateGroup(Set<Group> existing, String groupName, String description, String contactMail) {
        HashSet<String> existingNames = new HashSet<String>();
        int maxId = 0;
        for (Group g : existing) {
            existingNames.add(g.getName());
            if (maxId >= g.getId()) continue;
            maxId = g.getId();
        }
        String toUseName = GeoNetworkUtils.clashSafeString((String)groupName, existingNames);
        return new Group(toUseName, description, contactMail, Integer.valueOf(maxId + 1));
    }

    public static User generateUser(Set<User> existing, Integer passwordLength, String username) {
        HashSet<String> existingNames = new HashSet<String>();
        for (User g : existing) {
            existingNames.add(g.getUsername());
        }
        String toUseUserName = GeoNetworkUtils.clashSafeString((String)username, existingNames);
        return new User(Integer.valueOf(0), toUseUserName, StringUtils.generateRandomString((int)passwordLength), User.Profile.RegisteredUser);
    }

    public static String clashSafeString(String originalString, Set<String> existingSet) {
        String toReturn = originalString;
        int suffix = 1;
        while (existingSet.contains(toReturn)) {
            toReturn = String.valueOf(originalString) + "_" + suffix;
            ++suffix;
        }
        return toReturn;
    }

    public static long getIDByUUID(GeoNetworkClient client, String uuid) throws MetadataNotFoundException, GNLibException, GNServerException {
        log.debug("Looking for uuid : {} ", (Object)uuid);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, uuid);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = client.query(req);
        Iterator iterator = resp.iterator();
        log.debug("Got {} hits for UUID {}", (Object)resp.getCount(), (Object)uuid);
        while (iterator.hasNext()) {
            GNSearchResponse.GNMetadata meta = (GNSearchResponse.GNMetadata)iterator.next();
            if (!meta.getUUID().equals(uuid)) continue;
            return meta.getId();
        }
        throw new MetadataNotFoundException("Unable to find metadata from uuid " + uuid);
    }
}

