/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.gn.utils;

import it.geosolutions.geonetwork.exception.GNLibException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.gcube.spatial.data.sdi.model.gn.User;
import org.gcube.spatial.data.sdi.utils.StringUtils;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserUtils {
    public static Set<User> parseUserXMLResponse(String toParse) throws GNLibException {
        try {
            HashSet<User> toReturn = new HashSet<User>();
            SAXBuilder builder = new SAXBuilder();
            Element responseEl = builder.build((Reader)new StringReader(toParse)).detachRootElement();
            for (Object recordObj : responseEl.getChildren("record")) {
                Element record = (Element)recordObj;
                Integer id = Integer.parseInt(record.getChildText("id"));
                String username = record.getChildText("username");
                String password = record.getChildText("password");
                User.Profile profile = User.Profile.valueOf((String)record.getChildText("profile"));
                toReturn.add(new User(id, username, password, profile));
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new GNLibException("Unable to parse users XML response", (Throwable)e);
        }
    }

    public static Set<User> parseUserJSONResponse(String toParse) throws GNLibException {
        try {
            HashSet<User> toReturn = new HashSet<User>();
            JSONArray array = new JSONArray(toParse);
            int i = 0;
            while (i < array.length()) {
                JSONObject userObj = array.getJSONObject(i);
                Integer id = userObj.getInt("id");
                String username = userObj.getString("username");
                String password = null;
                User.Profile profile = User.Profile.valueOf((String)userObj.getString("profile"));
                toReturn.add(new User(id, username, password, profile));
                ++i;
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new GNLibException("Unable to parse users JSON response ", (Throwable)e);
        }
    }

    public static User generateRandomUser(Set<User> existing, Integer nameLenght, Integer passwordLength) {
        HashSet<String> existingNames = new HashSet<String>();
        for (User g : existing) {
            existingNames.add(g.getUsername());
        }
        return new User(Integer.valueOf(0), StringUtils.generateNewRandom(existingNames, (int)nameLenght), StringUtils.generateRandomString((int)passwordLength), User.Profile.RegisteredUser);
    }

    public static Set<Integer> parseGroupsByUserResponse(String toParse) throws GNLibException {
        try {
            HashSet<Integer> toReturn = new HashSet<Integer>();
            SAXBuilder builder = new SAXBuilder();
            Element responseEl = builder.build((Reader)new StringReader(toParse)).detachRootElement();
            for (Object recordObj : responseEl.getChildren("group")) {
                Element record = (Element)recordObj;
                Integer id = Integer.parseInt(record.getChildText("id"));
                toReturn.add(id);
            }
            return toReturn;
        }
        catch (Exception e) {
            throw new GNLibException("Unable to Groups By User XML response", (Throwable)e);
        }
    }

    public static User getByName(Set<User> toLookInto, String toLookFor) {
        for (User g : toLookInto) {
            if (!g.getUsername().equals(toLookFor)) continue;
            return g;
        }
        return null;
    }
}

