/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.cluster.GeoServiceController;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.OutdatedServiceEndpointException;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceInteractionException;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkClient;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GeoNetworkUtils;
import org.gcube.spatial.data.sdi.engine.impl.gn.utils.UserUtils;
import org.gcube.spatial.data.sdi.engine.impl.is.ISUtils;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.gn.Group;
import org.gcube.spatial.data.sdi.model.gn.User;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.gcube.spatial.data.sdi.utils.ScopeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoNetworkController
extends GeoServiceController<GeoNetworkDescriptor> {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkController.class);
    private static String scopeUserPrefix = null;
    private static String scopePasswordPrefix = null;
    private static String ckanUserPrefix = null;
    private static String ckanPasswordPrefix = null;
    private static String managerUserPrefix = null;
    private static String managerPasswordPrefix = null;
    private static String assignedScopePrefix = null;
    private static String defaultGroupPrefix = null;
    private static String sharedGroupPrefix = null;
    private static String confidentialGroupPrefix = null;
    private static String contextGroupPrefix = null;
    private static String suffixesProperty = null;
    private static String priorityProperty = null;
    private String suffixes;
    private Integer priority;

    public Integer getPriority() {
        return this.priority;
    }

    public GeoNetworkController(ServiceEndpoint serviceEndpoint) throws InvalidServiceEndpointException {
        super(serviceEndpoint);
    }

    protected void setServiceEndpoint(ServiceEndpoint toSet) {
        super.setServiceEndpoint(toSet);
        this.suffixes = this.getSEProperty(suffixesProperty, true);
        this.priority = Integer.parseInt(this.getSEProperty(priorityProperty, true));
    }

    protected GeoNetworkDescriptor getLiveDescriptor() {
        GeoNetworkDescriptor descriptor = new GeoNetworkDescriptor();
        descriptor.setBaseEndpoint(this.baseURL);
        descriptor.setVersion(this.version);
        String currentScopeName = ScopeUtils.getCurrentScopeName();
        String suffix = this.getSuffixByScope(currentScopeName);
        ArrayList<Credentials> availableCredentials = new ArrayList<Credentials>();
        availableCredentials.add(this.adminAccount);
        Credentials context = new Credentials(this.getSEProperty(scopeUserPrefix + suffix, true), this.getSEProperty(scopePasswordPrefix + suffix, true), AccessType.CONTEXT_USER);
        availableCredentials.add(context);
        Credentials ckan = new Credentials(this.getSEProperty(ckanUserPrefix + suffix, true), this.getSEProperty(ckanPasswordPrefix + suffix, true), AccessType.CKAN);
        availableCredentials.add(ckan);
        String managerUser = this.getSEProperty(managerUserPrefix + suffix, false);
        if (managerUser != null) {
            Credentials manager = new Credentials(managerUser, this.getSEProperty(managerPasswordPrefix + suffix, true), AccessType.CONTEXT_MANAGER);
            availableCredentials.add(manager);
        }
        descriptor.setAccessibleCredentials(availableCredentials);
        descriptor.setPriority(this.priority);
        descriptor.setContextGroup(this.getSEProperty(contextGroupPrefix + suffix, true));
        descriptor.setSharedGroup(this.getSEProperty(sharedGroupPrefix + suffix, true));
        String confidentialGroup = this.getSEProperty(confidentialGroupPrefix + suffix, false);
        if (confidentialGroup != null) {
            descriptor.setConfidentialGroup(confidentialGroup);
        }
        descriptor.setDefaultGroup(this.getSEProperty(defaultGroupPrefix + suffix, true));
        descriptor.setPublicGroup(LocalConfiguration.getProperty((String)"gn.groups.all"));
        return descriptor;
    }

    protected ServiceEndpoint.AccessPoint getTheRightAccessPoint(ServiceEndpoint endpoint) {
        for (ServiceEndpoint.AccessPoint declaredPoint : endpoint.profile().accessPoints().asCollection()) {
            if (!declaredPoint.name().equals(LocalConfiguration.getProperty((String)"gn.se.endpointName"))) continue;
            return declaredPoint;
        }
        return null;
    }

    protected void initServiceEndpoint() throws OutdatedServiceEndpointException, ServiceInteractionException {
        String scopeName = ScopeUtils.getCurrentScopeName();
        try {
            if (this.getSuffixByScope(scopeName) == null) {
                throw new InvalidServiceEndpointException("Scope not present in resource");
            }
        }
        catch (InvalidServiceEndpointException e) {
            this.insertScopeInfo(ScopeUtils.getCurrentScope());
        }
    }

    private void insertScopeInfo(String scope) throws OutdatedServiceEndpointException, ServiceInteractionException {
        String scopeName = ScopeUtils.getScopeName((String)scope);
        log.info("Creating scope {} configuration for GeoNetwork at {} ", (Object)scopeName, (Object)this.baseURL);
        log.debug("Instantiating client as admin..");
        GeoNetworkClient gnClient = new GeoNetworkClient(this.baseURL, this.version, this.adminAccount.getPassword(), this.adminAccount.getUsername());
        log.debug("Getting Users and groups from instance..");
        Set existingGroups = gnClient.getGroups();
        Set existingUsers = gnClient.getUsers();
        ArrayList<User> sharedGroupExternalUsers = new ArrayList<User>();
        ArrayList externalGroupsToAccess = new ArrayList();
        log.debug("Getting Siblings information from SE..");
        for (String siblingScope : ISUtils.getSiblingsScopesInResource((Resource)this.serviceEndpoint, (String)scope)) {
            try {
                this.getSuffixByScope(ScopeUtils.getScopeName((String)siblingScope));
                for (String username : this.getUserNamesByScope(siblingScope, true, true, false)) {
                    sharedGroupExternalUsers.add(UserUtils.getByName((Set)existingUsers, (String)username));
                }
                externalGroupsToAccess.addAll(this.getGroupIDSByScope(siblingScope, true, false, false));
            }
            catch (InvalidServiceEndpointException e) {
                log.debug("Sibling scope {} not found in resource. Skipping.", (Object)siblingScope);
            }
        }
        log.debug("Getting Parents information from SE..");
        for (String parentScope : ScopeUtils.getParentScopes((String)scope)) {
            try {
                this.getSuffixByScope(ScopeUtils.getScopeName((String)parentScope));
                for (String username : this.getUserNamesByScope(parentScope, true, true, false)) {
                    sharedGroupExternalUsers.add(UserUtils.getByName((Set)existingUsers, (String)username));
                }
                externalGroupsToAccess.addAll(this.getGroupIDSByScope(parentScope, true, true, false));
            }
            catch (InvalidServiceEndpointException e) {
                log.debug("Parent scope {} not found in resource. Skipping it. ", (Object)parentScope);
            }
        }
        log.debug("Creating groups..");
        String contactMail = LocalConfiguration.getProperty((String)"gn.contact.mail");
        int passwordLength = Integer.parseInt(LocalConfiguration.getProperty((String)"gn.password.length", (String)"10"));
        Group shared = GeoNetworkUtils.generateGroup((Set)existingGroups, (String)("Shared_" + scopeName), (String)("Shared metadata group for " + scopeName), (String)contactMail);
        shared = gnClient.createGroup(shared);
        existingGroups.add(shared);
        Group context = GeoNetworkUtils.generateGroup((Set)existingGroups, (String)("Context_" + scopeName), (String)("Context metadata group for " + scopeName), (String)contactMail);
        context = gnClient.createGroup(context);
        existingGroups.add(context);
        Group confidential = GeoNetworkUtils.generateGroup((Set)existingGroups, (String)("Confidential_" + scopeName), (String)("Confidential metadata group for " + scopeName), (String)contactMail);
        confidential = gnClient.createGroup(confidential);
        existingGroups.add(confidential);
        log.debug("Giving access to shared group from external scopes..");
        for (User toUpdate : sharedGroupExternalUsers) {
            gnClient.editUser(toUpdate, Collections.singleton(shared.getId()));
        }
        log.debug("Creating users..");
        User ckan = GeoNetworkUtils.generateUser((Set)existingUsers, (Integer)passwordLength, (String)("CKAN_" + scopeName));
        ckan.setId(gnClient.createUsers(ckan, Arrays.asList(shared.getId(), context.getId())).getId());
        existingUsers.add(ckan);
        User ctx = GeoNetworkUtils.generateUser((Set)existingUsers, (Integer)passwordLength, (String)("Ctx_" + scopeName));
        ArrayList ctxUserAccessibleGroups = new ArrayList();
        ctxUserAccessibleGroups.addAll(externalGroupsToAccess);
        ctxUserAccessibleGroups.add(shared.getId());
        ctxUserAccessibleGroups.add(context.getId());
        ctx.setId(gnClient.createUsers(ctx, ctxUserAccessibleGroups).getId());
        existingUsers.add(ctx);
        User manager = GeoNetworkUtils.generateUser((Set)existingUsers, (Integer)passwordLength, (String)("Mng_" + scopeName));
        ctxUserAccessibleGroups.add(confidential.getId());
        manager.setId(gnClient.createUsers(manager, ctxUserAccessibleGroups).getId());
        existingUsers.add(manager);
        log.debug("Inserting configuration in Service Endpoint");
        String generatedSuffix = GeoNetworkController.generateSuffix((String)this.suffixes);
        ArrayList<ServiceEndpoint.Property> toUpdateProperties = new ArrayList<ServiceEndpoint.Property>();
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(assignedScopePrefix + generatedSuffix, scopeName));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(scopeUserPrefix + generatedSuffix, ctx.getUsername()));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(scopePasswordPrefix + generatedSuffix, ISUtils.encryptString((String)ctx.getPassword())).encrypted(true));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(ckanUserPrefix + generatedSuffix, ckan.getUsername()));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(ckanPasswordPrefix + generatedSuffix, ISUtils.encryptString((String)ckan.getPassword())).encrypted(true));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(managerUserPrefix + generatedSuffix, manager.getUsername()));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(managerPasswordPrefix + generatedSuffix, ISUtils.encryptString((String)manager.getPassword())).encrypted(true));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(sharedGroupPrefix + generatedSuffix, shared.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(defaultGroupPrefix + generatedSuffix, shared.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(confidentialGroupPrefix + generatedSuffix, confidential.getId() + ""));
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(contextGroupPrefix + generatedSuffix, context.getId() + ""));
        String suffixesList = this.suffixes != null && !this.suffixes.trim().isEmpty() && this.suffixes != "," ? this.suffixes + "," + generatedSuffix : generatedSuffix;
        toUpdateProperties.add(new ServiceEndpoint.Property().nameAndValue(suffixesProperty, suffixesList));
        this.accessPoint.properties().addAll(toUpdateProperties);
        throw new OutdatedServiceEndpointException("Created scope configuration for " + scopeName);
    }

    private String getSuffixByScope(String scopeName) {
        log.debug("looking for scope {} suffix. Available suffixes are : {} ", (Object)scopeName, (Object)this.suffixes);
        if (this.suffixes != null) {
            for (String suff : this.suffixes.split(",")) {
                String propertyValue;
                if (suff == null || suff.isEmpty() || (propertyValue = this.getSEProperty(assignedScopePrefix + suff, false)) == null || !propertyValue.equals(scopeName)) continue;
                return suff;
            }
        }
        return null;
    }

    private static String generateSuffix(String existingSuffixes) {
        log.debug("Generating suffix, existing are : " + existingSuffixes);
        String[] suffixArray = existingSuffixes == null ? new String[]{} : existingSuffixes.split(",");
        int maxIndex = 0;
        for (String suff : suffixArray) {
            try {
                int actual = Integer.parseInt(suff);
                if (actual <= maxIndex) continue;
                maxIndex = actual;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        String generated = maxIndex + 1 + "";
        log.debug("Generated suffix is : " + generated);
        return generated;
    }

    private HashSet<String> getUserNamesByScope(String scope, boolean getContext, boolean getManager, boolean getCKAN) {
        HashSet<String> toReturn = new HashSet<String>();
        String scopeName = ScopeUtils.getScopeName((String)scope);
        String scopeSuffix = this.getSuffixByScope(scopeName);
        if (scopeSuffix != null) {
            String scopeManagerUserName;
            if (getContext) {
                toReturn.add(this.getSEProperty(scopeUserPrefix + scopeSuffix, true));
            }
            if (getManager && (scopeManagerUserName = this.getSEProperty(managerUserPrefix + scopeSuffix, false)) != null) {
                toReturn.add(scopeManagerUserName);
            }
            if (getCKAN) {
                toReturn.add(this.getSEProperty(ckanUserPrefix + scopeSuffix, true));
            }
        }
        return toReturn;
    }

    private HashSet<Integer> getGroupIDSByScope(String scope, boolean getShared, boolean getContext, boolean getConfidential) {
        HashSet<Integer> toReturn = new HashSet<Integer>();
        String scopeName = ScopeUtils.getScopeName((String)scope);
        String scopeSuffix = this.getSuffixByScope(scopeName);
        if (scopeSuffix != null) {
            String confidentialGroupName;
            if (getShared) {
                toReturn.add(Integer.parseInt(this.getSEProperty(sharedGroupPrefix + scopeSuffix, true)));
            }
            if (getContext) {
                toReturn.add(Integer.parseInt(this.getSEProperty(contextGroupPrefix + scopeSuffix, true)));
            }
            if (getConfidential && (confidentialGroupName = this.getSEProperty(confidentialGroupPrefix + scopeSuffix, true)) != null) {
                toReturn.add(Integer.parseInt(confidentialGroupName));
            }
        }
        return toReturn;
    }

    static {
        scopeUserPrefix = LocalConfiguration.getProperty((String)"gn.se.scope.user.prefix");
        scopePasswordPrefix = LocalConfiguration.getProperty((String)"gn.se.scope.password.prefix");
        ckanUserPrefix = LocalConfiguration.getProperty((String)"gn.se.ckan.user.prefix");
        ckanPasswordPrefix = LocalConfiguration.getProperty((String)"gn.se.ckan.password.prefix");
        managerUserPrefix = LocalConfiguration.getProperty((String)"gn.se.manager.user.prefix");
        managerPasswordPrefix = LocalConfiguration.getProperty((String)"gn.se.manager.password.prefix");
        assignedScopePrefix = LocalConfiguration.getProperty((String)"gn.se.assigned.scope.prefix");
        defaultGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.default.group.prefix");
        sharedGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.shared.group.prefix");
        confidentialGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.confidential.group.prefix");
        contextGroupPrefix = LocalConfiguration.getProperty((String)"gn.se.context.group.prefix");
        suffixesProperty = LocalConfiguration.getProperty((String)"gn.se.suffixes");
        priorityProperty = LocalConfiguration.getProperty((String)"gn.se.priority");
    }
}

