/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.gn.extension;

import it.geosolutions.geonetwork.exception.GNLibException;
import it.geosolutions.geonetwork.exception.GNServerException;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNPriv;
import it.geosolutions.geonetwork.util.GNPrivConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import it.geosolutions.geonetwork.util.HTTPUtils;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.engine.impl.faults.ServiceInteractionException;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GNClientExtension;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.GNMetadataAdminExtension;
import org.gcube.spatial.data.sdi.engine.impl.gn.extension.ServerAccess;
import org.gcube.spatial.data.sdi.engine.impl.gn.utils.GroupUtils;
import org.gcube.spatial.data.sdi.engine.impl.gn.utils.UserUtils;
import org.gcube.spatial.data.sdi.model.gn.Group;
import org.gcube.spatial.data.sdi.model.gn.User;
import org.gcube.spatial.data.sdi.model.service.GeoNetworkDescriptor;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoNetworkClient {
    private static final Logger log = LoggerFactory.getLogger(GeoNetworkClient.class);
    private ServerAccess access;
    private GNClientExtension theClient = null;
    private GeoNetworkDescriptor descriptor = null;

    public GeoNetworkClient(String baseURL, Version version, String password, String user, GeoNetworkDescriptor descriptor) {
        this(baseURL, version, password, user);
        this.descriptor = descriptor;
    }

    public GeoNetworkClient(String baseURL, Version version, String password, String user) {
        this.access = new ServerAccess(baseURL, version, password, user);
        this.theClient = new GNClientExtension(this.access);
    }

    public Group createGroup(Group group) throws ServiceInteractionException {
        try {
            this.theClient.createGroup(group.getName(), group.getDescription(), group.getMail(), group.getId());
            long submitTime = System.currentTimeMillis();
            long timeout = LocalConfiguration.getTTL((String)"gn.update.timeout");
            long wait = LocalConfiguration.getTTL((String)"gn.update.wait");
            log.debug("Waiting for created group to be available, timeout is {} ", (Object)timeout);
            Group created = null;
            do {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((created = GroupUtils.getByName((Set)this.theClient.getGroups(), (String)group.getName())) == null && System.currentTimeMillis() - submitTime >= timeout);
            if (created == null) {
                log.error("GN Update timeout {}ms reached. Group {} not created.", (Object)timeout, (Object)group);
                throw new ServiceInteractionException("Reached timeout while creating group " + group.getName());
            }
            return created;
        }
        catch (ServiceInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServiceInteractionException("Unable to create group. ", t);
        }
    }

    public Set<Group> getGroups() throws ServiceInteractionException {
        try {
            return this.theClient.getGroups();
        }
        catch (Exception e) {
            throw new ServiceInteractionException("Unable to get Groups from " + this.access, (Throwable)e);
        }
    }

    public Set<User> getUsers() throws ServiceInteractionException {
        try {
            return this.theClient.getUsers();
        }
        catch (Exception e) {
            throw new ServiceInteractionException("Unable to get Users from " + this.access, (Throwable)e);
        }
    }

    public User createUsers(User user, Collection<Integer> groups) throws ServiceInteractionException {
        try {
            this.theClient.createUser(user.getUsername(), user.getPassword(), user.getProfile(), groups);
            long submitTime = System.currentTimeMillis();
            long timeout = LocalConfiguration.getTTL((String)"gn.update.timeout");
            long wait = LocalConfiguration.getTTL((String)"gn.update.wait");
            log.debug("Waiting for created group to be available, timeout is {} ", (Object)timeout);
            User created = null;
            do {
                try {
                    Thread.sleep(wait);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((created = UserUtils.getByName((Set)this.theClient.getUsers(), (String)user.getUsername())) == null && System.currentTimeMillis() - submitTime >= timeout);
            if (created == null) {
                log.error("GN Update timeout {}ms reached. User {} not created.", (Object)timeout, (Object)user.getUsername());
                throw new ServiceInteractionException("Reached timeout while creating user " + user.getUsername());
            }
            return created;
        }
        catch (ServiceInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ServiceInteractionException("Unable to create User. ", t);
        }
    }

    public void editUser(User toEdit, Collection<Integer> toAddGroups) throws ServiceInteractionException {
        try {
            Set alreadyAddedGroups = this.getGroupsByUser(toEdit.getId());
            alreadyAddedGroups.addAll(toAddGroups);
            GNMetadataAdminExtension.editUser((HTTPUtils)this.theClient.getConnection(), (ServerAccess)this.access, (User)toEdit, (Collection)alreadyAddedGroups);
        }
        catch (Throwable t) {
            throw new ServiceInteractionException("Unable to create User. ", t);
        }
    }

    public Set<Integer> getGroupsByUser(Integer userId) throws ServiceInteractionException {
        try {
            return UserUtils.parseGroupsByUserResponse((String)GNMetadataAdminExtension.getUserGroupd((HTTPUtils)this.theClient.getConnection(), (ServerAccess)this.access, (Integer)userId));
        }
        catch (Throwable t) {
            throw new ServiceInteractionException(t);
        }
    }

    public long insertMetadata(String category, String styleSheet, boolean validate, int group, boolean makePublic, File metadataFile) throws GNLibException, GNServerException {
        GNInsertConfiguration configuration = new GNInsertConfiguration();
        configuration.setCategory(category);
        configuration.setStyleSheet(styleSheet);
        configuration.setValidate(Boolean.valueOf(validate));
        configuration.setGroup(group + "");
        log.debug("Inserting with {} ", (Object)configuration);
        long toReturnId = this.theClient.insertMetadata(configuration, metadataFile);
        GNPrivConfiguration privileges = makePublic ? GeoNetworkClient.getPrivileges((Integer[])new Integer[]{group, Integer.parseInt(this.descriptor.getPublicGroup())}) : GeoNetworkClient.getPrivileges((Integer[])new Integer[]{group});
        log.debug("Setting privileges {} on {} ", (Object)privileges, (Object)toReturnId);
        this.theClient.setPrivileges(toReturnId, privileges);
        return toReturnId;
    }

    private static final GNPrivConfiguration getPrivileges(Integer ... groups) {
        GNPrivConfiguration toReturn = new GNPrivConfiguration();
        for (Integer group : groups) {
            toReturn.addPrivileges(group, EnumSet.of(GNPriv.DOWNLOAD, new GNPriv[]{GNPriv.DYNAMIC, GNPriv.EDITING, GNPriv.FEATURED, GNPriv.NOTIFY, GNPriv.VIEW}));
        }
        return toReturn;
    }

    public void updateMeta(long toUpdateMetaId, File metadataFile) throws GNLibException, GNServerException {
        log.debug("Updating metadata by ID " + toUpdateMetaId);
        this.theClient.updateMetadata(toUpdateMetaId, metadataFile);
    }

    public GNSearchResponse query(GNSearchRequest request) throws GNLibException, GNServerException {
        return this.theClient.search(request);
    }
}

