/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spatial.data.sdi.engine.impl.is;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.spatial.data.sdi.LocalConfiguration;
import org.gcube.spatial.data.sdi.NetUtils;
import org.gcube.spatial.data.sdi.engine.impl.faults.InvalidServiceDefinitionException;
import org.gcube.spatial.data.sdi.engine.impl.is.AbstractISModule;
import org.gcube.spatial.data.sdi.model.credentials.AccessType;
import org.gcube.spatial.data.sdi.model.credentials.Credentials;
import org.gcube.spatial.data.sdi.model.health.Level;
import org.gcube.spatial.data.sdi.model.health.Status;
import org.gcube.spatial.data.sdi.model.service.ThreddsDescriptor;
import org.gcube.spatial.data.sdi.model.service.Version;
import org.gcube.spatial.data.sdi.model.services.ServiceDefinition;
import org.gcube.spatial.data.sdi.model.services.ThreddsDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreddsRetriever
extends AbstractISModule {
    private static final Logger log = LoggerFactory.getLogger(ThreddsRetriever.class);

    protected String getGCoreEndpointServiceClass() {
        return LocalConfiguration.getProperty((String)"th.ge.serviceClass");
    }

    protected String getGCoreEndpointServiceName() {
        return LocalConfiguration.getProperty((String)"th.ge.serviceName");
    }

    protected String getManagedServiceType() {
        return "THREDDS";
    }

    protected String getServiceEndpointCategory() {
        return LocalConfiguration.getProperty((String)"th.se.category");
    }

    protected String getServiceEndpointPlatformName() {
        return LocalConfiguration.getProperty((String)"th.se.platform");
    }

    protected String getServiceEndpointAccessPointName() {
        return LocalConfiguration.getProperty((String)"th.se.endpointName");
    }

    protected boolean isSmartGearsMandatory() {
        return LocalConfiguration.getFlag((String)"th.mandatorySG");
    }

    protected List<Status> performInstanceCheck(ServiceEndpoint se) {
        ArrayList<Status> toReturn = new ArrayList<Status>();
        String hostname = se.profile().runtime().hostedOn();
        try {
            log.trace("Checking thredds hosted on {} ", (Object)hostname);
            String publicCatalogUrl = "https://" + hostname + "/thredds/catalog/public/netcdf/catalog.html";
            if (!NetUtils.isUp((String)publicCatalogUrl)) {
                toReturn.add(new Status("Unreachable default THREDDS catalog at " + publicCatalogUrl, Level.ERROR));
            }
        }
        catch (IOException e) {
            String msg = "Unable to check thredds instance hosted on " + hostname;
            log.warn(msg, (Throwable)e);
            toReturn.add(new Status(msg, Level.WARNING));
        }
        return toReturn;
    }

    private static final ThreddsDescriptor translate(ServiceEndpoint toTranslate) {
        Platform platform = toTranslate.profile().platform();
        Version version = new Version(Short.valueOf(platform.version()), platform.minorVersion(), platform.revisionVersion());
        ServiceEndpoint.AccessPoint access = (ServiceEndpoint.AccessPoint)toTranslate.profile().accessPoints().iterator().next();
        Credentials credentials = new Credentials(access.username(), access.password(), AccessType.ADMIN);
        return new ThreddsDescriptor(version, access.address(), Collections.singletonList(credentials));
    }

    protected void checkDefinitionForServiceType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
    }

    protected void checkDefinitionType(ServiceDefinition definition) throws InvalidServiceDefinitionException {
        if (!definition.getType().equals((Object)ServiceDefinition.Type.THREDDS) || !(definition instanceof ThreddsDefinition)) {
            throw new InvalidServiceDefinitionException("Invalid service type [expected " + ServiceDefinition.Type.THREDDS + "]. Definition was " + definition);
        }
    }
}

