/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl.threads;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.ExecutionReport;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.data.transfer.model.RemoteFileDescriptor;
import org.gcube.data.transfer.model.plugins.thredds.DataSet;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.spatial.data.sdi.interfaces.Metadata;
import org.gcube.spatial.data.sdi.model.metadata.MetadataPublishOptions;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocationBuilder;
import org.gcube.spatial.data.sdi.plugins.SDIAbstractPlugin;
import org.gcube.usecases.ws.thredds.NetUtils;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessStatus;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceUtils;
import org.gcube.usecases.ws.thredds.engine.impl.threads.DeleteRemoteRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.ProcessIdProvider;
import org.gcube.usecases.ws.thredds.engine.impl.threads.RequestLogger;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferFromThreddsRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferToThreddsRequest;
import org.gcube.usecases.ws.thredds.faults.CancellationException;
import org.gcube.usecases.ws.thredds.faults.DataTransferPluginError;
import org.gcube.usecases.ws.thredds.faults.RemoteFileNotFoundException;
import org.gcube.usecases.ws.thredds.model.StepReport;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.gcube.usecases.ws.thredds.model.SynchronizedElementInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationThread.class);
    private static final Object $LOCK = new Object[0];
    private SynchronizationRequest theRequest;

    public SynchronizationThread(SynchronizationRequest theRequest) {
        this.theRequest = theRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProcessIdProvider.instance.set(this.theRequest.getProcess().getDescriptor().getProcessId());
        log.debug("Executing Transfer request {} ", (Object)this.theRequest);
        RequestLogger.get().log(this.theRequest);
        String reportMessage = "Never started";
        String reportItemName = "Still Unknown";
        StepReport.Status toSetStatus = StepReport.Status.ERROR;
        WorkspaceFolder parentFolder = this.theRequest.getLocation();
        try {
            this.checkCancelledProcess();
            SynchFolderConfiguration synchConfig = WorkspaceUtils.loadConfiguration((WorkspaceItem)this.theRequest.getLocation());
            ThreddsController controller = new ThreddsController(synchConfig.getRemotePath(), synchConfig.getTargetToken());
            if (this.theRequest instanceof TransferToThreddsRequest) {
                String itemName;
                TransferToThreddsRequest request = (TransferToThreddsRequest)this.theRequest;
                WorkspaceItem item = request.getToTransfer();
                reportItemName = itemName = item.getName();
                String toLookMetadataName = itemName.substring(0, itemName.lastIndexOf(".")) + ".xml";
                WorkspaceItem metadataItem = SynchronizationThread.getFileByName(item.getParent(), false, toLookMetadataName);
                Destination toSetDestination = new Destination();
                toSetDestination.setCreateSubfolders(Boolean.valueOf(true));
                toSetDestination.setDestinationFileName(itemName);
                toSetDestination.setOnExistingFileName(DestinationClashPolicy.REWRITE);
                toSetDestination.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
                toSetDestination.setPersistenceId(synchConfig.getRemotePersistence());
                String fileLocation = request.getLocation().getProperties().getPropertyValue("WS-SYNCH.REMOTE-PATH");
                toSetDestination.setSubFolder(fileLocation);
                this.checkCancelledProcess();
                Set<PluginInvocation> invocations = null;
                if (metadataItem == null) {
                    log.debug("Metadata not found, asking SIS/GEOTK for generation..");
                    invocations = Collections.singleton(new PluginInvocation("SIS/GEOTK"));
                }
                log.info("Transferring to {} with invocations {} ", (Object)toSetDestination, invocations);
                ThreddsInfo info = controller.getThreddsInfo();
                DataSet dataset = info.getDataSetFromLocation(info.getLocalBasePath() + "/" + fileLocation);
                this.checkCancelledProcess();
                TransferResult result = controller.transferFile(toSetDestination, item.getPublicLink(false), invocations);
                HashMap<String, String> toSetProperties = new HashMap<String, String>();
                String toSetMetadataUUID = null;
                Boolean validateMetadata = synchConfig.getValidateMetadata();
                this.checkCancelledProcess();
                if (metadataItem == null) {
                    ExecutionReport report = (ExecutionReport)result.getExecutionReports().get("SIS/GEOTK");
                    if (!report.getFlag().equals((Object)ExecutionReport.ExecutionReportFlag.SUCCESS)) {
                        throw new DataTransferPluginError("Unable to Extract Metadata for " + itemName + " Message is " + report.getMessage());
                    }
                    toSetMetadataUUID = report.getMessage();
                } else {
                    MetadataReport metaReport = SynchronizationThread.publishMetadata(metadataItem, info.getHostname(), itemName, dataset.getPath(), validateMetadata);
                    toSetMetadataUUID = metaReport.getPublishedUUID();
                }
                toSetProperties.put("WS-SYNCH.LAST-UPDATE-TIME", controller.getFileDescriptor(itemName).getLastUpdate() + "");
                toSetProperties.put("WS-SYNCH.METADATA-UUID", toSetMetadataUUID);
                toSetProperties.put("WS-SYNCH.SYNCH-STATUS", (Object)((Object)SynchronizedElementInfo.SynchronizationStatus.UP_TO_DATE) + "");
                item.getProperties().addProperties(toSetProperties);
                reportMessage = "Successfully transferred and published.";
            } else if (this.theRequest instanceof TransferFromThreddsRequest) {
                HashMap<String, String> toSetProperties = new HashMap<String, String>();
                TransferFromThreddsRequest importRequest = (TransferFromThreddsRequest)this.theRequest;
                String toImportName = null;
                WorkspaceItem targetItem = null;
                if (importRequest.getTargetItem() == null) {
                    toImportName = importRequest.getRemoteFilename();
                    reportMessage = "Importing remote file..";
                } else {
                    toImportName = importRequest.getTargetItem().getName();
                    targetItem = importRequest.getTargetItem();
                    reportMessage = "Updating file..";
                }
                reportItemName = toImportName;
                RemoteFileDescriptor toImport = controller.getFileDescriptor(toImportName);
                toSetProperties.put("WS-SYNCH.LAST-UPDATE-TIME", toImport.getLastUpdate() + "");
                try (InputStream source = null;){
                    source = controller.getInputStream(toImportName);
                    if (targetItem == null) {
                        targetItem = parentFolder.createExternalFileItem(toImportName, "Imported from Thredds", null, source);
                    } else {
                        targetItem.updateItem(source);
                    }
                    targetItem.getProperties().addProperties(toSetProperties);
                }
                reportMessage = "File successfully imported";
            } else if (this.theRequest instanceof DeleteRemoteRequest) {
                DeleteRemoteRequest deleteRequest = (DeleteRemoteRequest)this.theRequest;
                reportItemName = deleteRequest.getToRemoveName();
                log.debug("Going to delete {} from ", (Object)reportItemName, (Object)synchConfig.getRemotePath());
                RemoteFileDescriptor desc = controller.getFileDescriptor(reportItemName);
                if (desc.isDirectory()) {
                    log.debug("Remote {} is directory.. Cleaning it up, first.", (Object)reportItemName);
                    controller.createEmptyFolder(null);
                }
                controller.deleteThreddsFile(reportItemName);
                reportMessage = "Successfully removed";
            }
            log.info("Synchronization of {} successful.", (Object)reportItemName);
            toSetStatus = StepReport.Status.OK;
        }
        catch (CancellationException e) {
            log.debug("Process cancelled.. ", (Throwable)e);
            reportMessage = "CancelledProcess";
            toSetStatus = StepReport.Status.CANCELLED;
        }
        catch (DataTransferPluginError e) {
            log.debug("Unable to extract metadata ", (Throwable)e);
            reportMessage = "Unable to extract metadata : " + e.getMessage();
            toSetStatus = StepReport.Status.ERROR;
        }
        catch (RemoteFileNotFoundException e) {
            log.debug("Remote File not found ", (Throwable)e);
            reportMessage = "Remote File not found : " + e.getMessage();
            toSetStatus = StepReport.Status.ERROR;
        }
        catch (InternalErrorException e) {
            log.debug("Internal generic exception ", (Throwable)e);
            reportMessage = "Internal error : " + e.getMessage();
            toSetStatus = StepReport.Status.ERROR;
        }
        catch (Throwable t) {
            log.debug("Internal generic exception ", t);
            reportMessage = "Unexpected exception : " + t.getMessage();
            toSetStatus = StepReport.Status.ERROR;
        }
        finally {
            SynchronizationThread.updateParentProperty(parentFolder, toSetStatus);
            this.submitReport(reportItemName, reportMessage, toSetStatus);
            ProcessIdProvider.instance.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateParentProperty(WorkspaceFolder folder, StepReport.Status toSetStatus) {
        Object object = $LOCK;
        synchronized (object) {
            try {
                String currentValue = (String)folder.getProperties().getProperties().get("WS-SYNCH.LAST-UPDATE-STATUS");
                if (currentValue == null || currentValue.isEmpty() || currentValue.equals("null")) {
                    folder.getProperties().addProperties(Collections.singletonMap("WS-SYNCH.LAST-UPDATE-STATUS", (Object)((Object)toSetStatus) + ""));
                } else {
                    StepReport.Status currentWSStatus = StepReport.Status.valueOf(currentValue);
                    if (currentWSStatus.equals((Object)StepReport.Status.OK) && !toSetStatus.equals((Object)currentWSStatus)) {
                        folder.getProperties().addProperties(Collections.singletonMap("WS-SYNCH.LAST-UPDATE-STATUS", (Object)((Object)toSetStatus) + ""));
                    }
                }
            }
            catch (Throwable t) {
                log.warn("Unable to update folder status ", t);
            }
        }
    }

    private void checkCancelledProcess() throws CancellationException {
        if (this.theRequest.getProcess().getStatus().getStatus().equals((Object)ProcessStatus.Status.STOPPED)) {
            throw new CancellationException("Process " + this.theRequest.getProcess().getDescriptor().getProcessId() + " has been cancelled");
        }
    }

    private void submitReport(String elementName, String message, StepReport.Status status) {
        StepReport report = new StepReport(elementName, message, status, StepReport.OperationType.WS_TO_TH, System.currentTimeMillis());
        if (this.theRequest instanceof TransferToThreddsRequest) {
            report.setOperationType(StepReport.OperationType.WS_TO_TH);
        } else if (this.theRequest instanceof TransferFromThreddsRequest) {
            report.setOperationType(StepReport.OperationType.TH_TO_WS);
        } else if (this.theRequest instanceof DeleteRemoteRequest) {
            report.setOperationType(StepReport.OperationType.DELETE_REMOTE);
        } else {
            throw new RuntimeException("Unknown operation request " + this.theRequest);
        }
        this.theRequest.getProcess().onStep(report);
    }

    private static MetadataReport publishMetadata(WorkspaceItem toPublish, String threddsHostname, String filename, String publicPath, Boolean validate) throws Exception {
        File tempMetaFile = null;
        try {
            Metadata meta = (Metadata)SDIAbstractPlugin.metadata().build();
            tempMetaFile = NetUtils.download(toPublish.getPublicLink(false));
            log.debug("Publishing metadata {} ", (Object)filename);
            MetadataPublishOptions opts = new MetadataPublishOptions((Set)new TemplateInvocationBuilder().threddsOnlineResources(threddsHostname, filename, publicPath).get());
            opts.setGeonetworkCategory("Datasets");
            opts.setValidate(validate.booleanValue());
            return meta.pushMetadata(tempMetaFile, opts);
        }
        catch (Throwable t) {
            if (tempMetaFile != null) {
                Files.deleteIfExists(tempMetaFile.toPath());
            }
            throw new Exception("Something went wrong while publishing metadata for " + filename + ". Cause : " + t.getMessage(), t);
        }
    }

    private static final WorkspaceItem getFileByName(WorkspaceFolder toLookIntoFolder, boolean recursive, String toLookForName) throws InternalErrorException {
        log.debug("Looking for {} into {} [recursive {} ]", new Object[]{toLookForName, toLookIntoFolder.getPath() + " ID " + toLookIntoFolder.getId(), recursive});
        for (WorkspaceItem item : toLookIntoFolder.getChildren()) {
            if (item.isFolder() || !item.getName().equals(toLookForName)) continue;
            return item;
        }
        if (recursive) {
            for (WorkspaceItem item : toLookIntoFolder.getChildren()) {
                if (!item.isFolder()) continue;
                return SynchronizationThread.getFileByName((WorkspaceFolder)item, recursive, toLookForName);
            }
        }
        return null;
    }
}

