/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl.threads;

import java.io.File;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.spatial.data.sdi.interfaces.Metadata;
import org.gcube.spatial.data.sdi.model.metadata.MetadataPublishOptions;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.model.metadata.TemplateInvocationBuilder;
import org.gcube.spatial.data.sdi.plugins.SDIAbstractPlugin;
import org.gcube.usecases.ws.thredds.NetUtils;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessStatus;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceUtils;
import org.gcube.usecases.ws.thredds.engine.impl.threads.DeleteRemoteRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.SynchronizationRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferFromThreddsRequest;
import org.gcube.usecases.ws.thredds.engine.impl.threads.TransferToThreddsRequest;
import org.gcube.usecases.ws.thredds.faults.CancellationException;
import org.gcube.usecases.ws.thredds.model.StepReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationThread.class);
    private static final Object $LOCK = new Object[0];
    private SynchronizationRequest theRequest;

    public SynchronizationThread(SynchronizationRequest theRequest) {
        this.theRequest = theRequest;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateParentProperty(FolderItem folderItem, StepReport.Status toSetStatus) {
        Object object = $LOCK;
        synchronized (object) {
            try {
                FolderContainer folder = WorkspaceUtils.getClient().open(folderItem.getId()).asFolder();
                org.gcube.common.storagehub.model.Metadata folderMeta = ((FolderItem)folder.get()).getMetadata();
                Map props = folderMeta.getMap();
                String currentValue = "" + props.get("WS-SYNCH.LAST-UPDATE-STATUS");
                if (currentValue == null || currentValue.isEmpty() || currentValue.equals("null")) {
                    props.put("WS-SYNCH.LAST-UPDATE-STATUS", "" + (Object)((Object)toSetStatus));
                } else {
                    StepReport.Status currentWSStatus = StepReport.Status.valueOf(currentValue);
                    if (currentWSStatus.equals((Object)StepReport.Status.OK) && !toSetStatus.equals((Object)currentWSStatus)) {
                        props.put("WS-SYNCH.LAST-UPDATE-STATUS", "" + (Object)((Object)toSetStatus));
                    }
                }
                folderMeta.setMap(props);
                folder.setMetadata(folderMeta);
            }
            catch (Throwable t) {
                log.warn("Unable to update folder status ", t);
            }
        }
    }

    private void checkCancelledProcess() throws CancellationException {
        if (this.theRequest.getProcess().getStatus().getStatus().equals((Object)ProcessStatus.Status.STOPPED)) {
            throw new CancellationException("Process " + this.theRequest.getProcess().getDescriptor().getProcessId() + " has been cancelled");
        }
    }

    private void submitReport(String elementName, String message, StepReport.Status status) {
        StepReport report = new StepReport(elementName, message, status, StepReport.OperationType.WS_TO_TH, System.currentTimeMillis());
        if (this.theRequest instanceof TransferToThreddsRequest) {
            report.setOperationType(StepReport.OperationType.WS_TO_TH);
        } else if (this.theRequest instanceof TransferFromThreddsRequest) {
            report.setOperationType(StepReport.OperationType.TH_TO_WS);
        } else if (this.theRequest instanceof DeleteRemoteRequest) {
            report.setOperationType(StepReport.OperationType.DELETE_REMOTE);
        } else {
            throw new RuntimeException("Unknown operation request " + this.theRequest);
        }
        this.theRequest.getProcess().onStep(report);
    }

    private static MetadataReport publishMetadata(FileContainer toPublish, String threddsHostname, String filename, String publicPath, Boolean validate) throws Exception {
        File tempMetaFile = null;
        try {
            Metadata meta = (Metadata)SDIAbstractPlugin.metadata().build();
            tempMetaFile = NetUtils.download(toPublish.getPublicLink());
            log.debug("Publishing metadata {} ", (Object)filename);
            MetadataPublishOptions opts = new MetadataPublishOptions((Set)new TemplateInvocationBuilder().threddsOnlineResources(threddsHostname, filename, publicPath).get());
            opts.setGeonetworkCategory("Datasets");
            opts.setValidate(validate.booleanValue());
            return meta.pushMetadata(tempMetaFile, opts);
        }
        catch (Throwable t) {
            if (tempMetaFile != null) {
                Files.deleteIfExists(tempMetaFile.toPath());
            }
            throw new Exception("Something went wrong while publishing metadata for " + filename + ". Cause : " + t.getMessage(), t);
        }
    }

    private static final FileContainer getFileByName(FolderContainer toLookIntoFolder, boolean recursive, String toLookForName) throws StorageHubException {
        log.debug(String.format("Looking for %1$s into %2$s [recursive %3$s ]", toLookForName, String.valueOf(((FolderItem)toLookIntoFolder.get()).getPath()) + " ID " + toLookIntoFolder.getId(), recursive));
        for (ItemContainer item : toLookIntoFolder.list().withMetadata().withAccounting().getContainers()) {
            if (item.getType().equals((Object)ContainerType.FOLDER) || !item.get().getName().equals(toLookForName)) continue;
            return (FileContainer)item;
        }
        if (recursive) {
            for (ItemContainer item : toLookIntoFolder.list().withMetadata().withAccounting().getContainers()) {
                if (!item.getType().equals((Object)ContainerType.FOLDER)) continue;
                return SynchronizationThread.getFileByName((FolderContainer)item, recursive, toLookForName);
            }
        }
        return null;
    }
}

