/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine;

import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import lombok.NonNull;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.data.transfer.library.DataTransferClient;
import org.gcube.data.transfer.library.TransferResult;
import org.gcube.data.transfer.library.faults.DestinationNotSetException;
import org.gcube.data.transfer.library.faults.FailedTransferException;
import org.gcube.data.transfer.library.faults.InitializationException;
import org.gcube.data.transfer.library.faults.InvalidDestinationException;
import org.gcube.data.transfer.library.faults.InvalidSourceException;
import org.gcube.data.transfer.library.faults.ServiceNotFoundException;
import org.gcube.data.transfer.library.faults.SourceNotSetException;
import org.gcube.data.transfer.library.faults.UnreachableNodeException;
import org.gcube.data.transfer.model.Destination;
import org.gcube.data.transfer.model.DestinationClashPolicy;
import org.gcube.data.transfer.model.PluginInvocation;
import org.gcube.spatial.data.sdi.model.metadata.MetadataReport;
import org.gcube.spatial.data.sdi.utils.ScopeUtils;
import org.gcube.usecases.ws.thredds.Commons;
import org.gcube.usecases.ws.thredds.NetUtils;
import org.gcube.usecases.ws.thredds.TokenSetter;
import org.gcube.usecases.ws.thredds.engine.PublishReport;
import org.gcube.usecases.ws.thredds.engine.PublishRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PublishThread.class);
    @NonNull
    private PublishRequest request;
    @NonNull
    private ConcurrentHashMap<String, PublishReport> reports;
    private PublishReport publishReport;
    private static ConcurrentHashMap<String, Semaphore> semaphores = new ConcurrentHashMap();

    @Override
    public void run() {
        log.info("Request is {}", (Object)this.request);
        log.debug("Switching from {} to {}", (Object)SecurityTokenProvider.instance.get(), (Object)this.request.getPublishToken());
        TokenSetter.setToken(this.request.getPublishToken());
        log.debug("Current scope is :{}, token is {} ", (Object)ScopeUtils.getCurrentScope(), (Object)SecurityTokenProvider.instance.get());
        Destination dest = new Destination();
        dest.setPersistenceId("thredds");
        dest.setSubFolder("public/netcdf/" + this.request.getCatalog());
        dest.setOnExistingFileName(DestinationClashPolicy.REWRITE);
        dest.setCreateSubfolders(Boolean.valueOf(true));
        dest.setOnExistingSubFolder(DestinationClashPolicy.APPEND);
        try {
            TransferResult result;
            String threddsHostName = Commons.getThreddsHost();
            DataTransferClient client = Commons.getDTClient(threddsHostName);
            File toPublishSource = null;
            if (this.request.getMode().equals((Object)PublishRequest.Mode.NCML) && this.request.isQueue()) {
                log.debug("Waiting for queue {}, expected Count {} ", (Object)this.request.getQueueId(), (Object)this.request.getQueueCount());
                PublishThread.waitFor(this.request.getQueueId(), this.request.getQueueCount());
                log.debug("Loading netcdfFile ..");
                File ncmlFile = NetUtils.download(new URL(this.request.getSource().getUrl()));
                String toUpdateSource = new String(Files.readAllBytes(ncmlFile.toPath()));
                for (String reportId : this.request.getToGatherReportsId()) {
                    PublishReport report = this.getReport(reportId);
                    String toSetUrl = "file:/" + report.getTransferResult().getRemotePath();
                    toUpdateSource = toUpdateSource.replaceAll(reportId, toSetUrl);
                }
                toPublishSource = File.createTempFile("nc_", ".ncml");
                PrintWriter out = new PrintWriter(toPublishSource);
                out.write(toUpdateSource);
                out.flush();
            }
            if (!this.request.isGenerateMeta()) {
                log.debug("Transfering before publishing meta..");
                result = toPublishSource == null ? client.httpSource(this.request.getSource().getUrl(), dest) : client.localFile(toPublishSource, dest);
                this.publishReport = new PublishReport(false, this.request.getSource().getId(), this.request.getSource().getName(), result, new MetadataReport());
            } else {
                log.debug("Metadata not provided.. ");
                if (this.request.isQueue() && this.request.getMode().equals((Object)PublishRequest.Mode.NC)) {
                    log.debug("Dataset file is linked in ncml, skipping metadata generation");
                    result = client.httpSource(this.request.getSource().getUrl(), dest);
                } else {
                    result = client.httpSource(this.request.getSource().getUrl(), dest, new PluginInvocation("SIS/GEOTK"));
                }
                this.publishReport = new PublishReport(false, this.request.getSource().getId(), this.request.getSource().getName(), result, null);
            }
        }
        catch (ServiceNotFoundException | UnreachableNodeException e) {
            log.error("Unable to find Thredds. Publish scope is {} ", (Object)ScopeUtils.getCurrentScope(), (Object)e);
        }
        catch (DestinationNotSetException | FailedTransferException | InitializationException | InvalidDestinationException | InvalidSourceException | SourceNotSetException e) {
            log.error("Unable to transfer file, ", e);
        }
        catch (IOException e) {
            log.error("Unable to read/ write file. ", (Throwable)e);
        }
        this.onCompletion();
    }

    private void onCompletion() {
        if (this.publishReport == null) {
            this.publishReport = new PublishReport(true, this.request.getSource().getId(), this.request.getSource().getName(), null, null);
        }
        this.publishReport(this.publishReport);
        if (this.request.getMode().equals((Object)PublishRequest.Mode.NC) && this.request.isQueue()) {
            PublishThread.alert(this.request.getQueueId(), this.request.getQueueCount());
        }
    }

    private PublishReport getReport(String reportId) {
        return this.reports.get(reportId);
    }

    private void publishReport(PublishReport report) {
        this.reports.put(report.getSourceId(), report);
    }

    private static void waitFor(String queueId, Integer expected) {
        try {
            log.debug("Waiting for queue {}. Expected Count is {} ", (Object)queueId, (Object)expected);
            semaphores.getOrDefault(queueId, new Semaphore(expected * -1)).acquire();
        }
        catch (InterruptedException e) {
            log.debug("Queue {} is completed.");
        }
    }

    private static void alert(String queueId, Integer expected) {
        log.debug("Alerting queue {}. Expected count is {} ", (Object)queueId, (Object)expected);
        Semaphore sem = semaphores.getOrDefault(queueId, new Semaphore(expected * -1));
        sem.release();
        log.debug(String.format("Queue %1$s alerted. Remaining : %2$s out of %3$s ", queueId, sem.availablePermits(), expected));
    }

    @ConstructorProperties(value={"request", "reports"})
    public PublishThread(@NonNull PublishRequest request, @NonNull ConcurrentHashMap<String, PublishReport> reports) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (reports == null) {
            throw new NullPointerException("reports");
        }
        this.request = request;
        this.reports = reports;
    }
}

