/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.gcube.data.transfer.model.plugins.thredds.DataSetScan;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsCatalog;
import org.gcube.data.transfer.model.plugins.thredds.ThreddsInfo;
import org.gcube.usecases.ws.thredds.LocalConfiguration;
import org.gcube.usecases.ws.thredds.SyncEngine;
import org.gcube.usecases.ws.thredds.engine.impl.Process;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessDescriptor;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessStatus;
import org.gcube.usecases.ws.thredds.engine.impl.ThreddsController;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceFolderManager;
import org.gcube.usecases.ws.thredds.engine.impl.threads.ProcessInitializationThread;
import org.gcube.usecases.ws.thredds.engine.impl.threads.RequestLogger;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.ProcessNotFoundException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceFolderNotRootException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceLockedException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceNotSynchedException;
import org.gcube.usecases.ws.thredds.model.CompletionCallback;
import org.gcube.usecases.ws.thredds.model.SyncEngineStatusDescriptor;
import org.gcube.usecases.ws.thredds.model.SyncFolderDescriptor;
import org.gcube.usecases.ws.thredds.model.SyncOperationCallBack;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.gcube.usecases.ws.thredds.model.SynchronizedElementInfo;
import org.gcube.usecases.ws.thredds.model.gui.CatalogBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchEngineImpl
implements SyncEngine {
    private static final Logger log = LoggerFactory.getLogger(SynchEngineImpl.class);
    private static SynchEngineImpl instance = null;
    private String requestLoggerPath = null;
    private ConcurrentHashMap<String, Process> localProcesses;
    private ExecutorService initializationExecutor = null;
    private ExecutorService synchronizationExecutor = null;
    private final CompletionCallback completionCallback = new CompletionCallback(){

        @Override
        public void onProcessCompleted(Process completedProcess) {
            try {
                ProcessDescriptor descriptor = completedProcess.getDescriptor();
                log.info("Process {} is completed. Going to cleanup.. ", (Object)descriptor);
                SynchEngineImpl.this.localProcesses.remove(descriptor.getFolderId());
                completedProcess.cleanup();
            }
            catch (Throwable t) {
                log.warn("Unable to cleanup {} ", (Object)completedProcess, (Object)t);
            }
        }
    };

    public static synchronized SyncEngine get() {
        if (instance == null) {
            instance = new SynchEngineImpl();
        }
        return instance;
    }

    private SynchEngineImpl() {
        this.localProcesses = new ConcurrentHashMap();
        int scannerMaxSize = Integer.parseInt(LocalConfiguration.getProperty("scanner.pool.maxSize"));
        int scannerCoreSize = Integer.parseInt(LocalConfiguration.getProperty("scanner.pool.coreSize"));
        int scannerIdleMs = Integer.parseInt(LocalConfiguration.getProperty("scanner.pool.idle.ms"));
        int transfersMaxSize = Integer.parseInt(LocalConfiguration.getProperty("transfers.pool.maxSize"));
        int transfersCoreSize = Integer.parseInt(LocalConfiguration.getProperty("transfers.pool.coreSize"));
        int transfersIdleMs = Integer.parseInt(LocalConfiguration.getProperty("transfers.pool.idle.ms"));
        this.initializationExecutor = new ThreadPoolExecutor(scannerCoreSize, scannerMaxSize, scannerIdleMs, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.synchronizationExecutor = new ThreadPoolExecutor(transfersCoreSize, transfersMaxSize, transfersIdleMs, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void setRequestLogger(String path) {
        this.requestLoggerPath = path;
    }

    @Override
    public boolean isRequestLoggerEnabled() {
        return this.requestLoggerPath != null;
    }

    @Override
    public String getRequestLoggerPath() {
        return this.requestLoggerPath;
    }

    @Override
    public SyncFolderDescriptor check(String folderId, boolean recursively) throws WorkspaceInteractionException, InternalException {
        WorkspaceFolderManager manager = new WorkspaceFolderManager(folderId);
        return manager.check(recursively);
    }

    @Override
    public void registerCallBack(String folderId, SyncOperationCallBack callback) throws ProcessNotFoundException {
        if (!this.localProcesses.containsKey(folderId)) {
            throw new ProcessNotFoundException(folderId + " is not under local processes");
        }
        this.localProcesses.get(folderId).addCallBack(callback);
    }

    @Override
    public ProcessDescriptor doSync(String folderId) throws WorkspaceInteractionException, InternalException {
        if (this.localProcesses.containsKey(folderId)) {
            return this.localProcesses.get(folderId).getDescriptor();
        }
        WorkspaceFolderManager manager = new WorkspaceFolderManager(folderId);
        if (!manager.isSynched()) {
            throw new WorkspaceNotSynchedException("Folder " + folderId + " is not configured for synchronization.");
        }
        if (manager.isLocked()) {
            throw new WorkspaceLockedException("Folder " + folderId + "is locked by an external process.");
        }
        if (!manager.isRoot()) {
            throw new WorkspaceFolderNotRootException("Unable to launch synch operation. Folder " + folderId + " is not root configuration");
        }
        Process toLaunch = new Process(folderId, this.completionCallback);
        this.localProcesses.put(folderId, toLaunch);
        this.initializationExecutor.submit(new ProcessInitializationThread(toLaunch, this.synchronizationExecutor));
        return toLaunch.getDescriptor();
    }

    @Override
    public void stopSynch(String folderId) throws ProcessNotFoundException {
        if (!this.localProcesses.containsKey(folderId)) {
            throw new ProcessNotFoundException(folderId + " is not under local processes");
        }
        this.localProcesses.get(folderId).cancel();
    }

    @Override
    public void setSynchronizedFolder(SynchFolderConfiguration config, String folderId) throws WorkspaceInteractionException, InternalException {
        if (config == null) {
            throw new InternalException("Passed config is null : " + config);
        }
        String remotePath = config.getRemotePath();
        if (remotePath == null || remotePath.isEmpty() || remotePath.startsWith("/")) {
            throw new InternalException("Invalid remote path " + remotePath + ".");
        }
        new WorkspaceFolderManager(folderId).configure(config);
    }

    @Override
    public void unsetSynchronizedFolder(String folderId, boolean deleteRemoteContent) throws WorkspaceInteractionException, InternalException {
        new WorkspaceFolderManager(folderId).dismiss(deleteRemoteContent);
    }

    @Override
    public SynchronizedElementInfo getInfo(String elementId) {
        return WorkspaceFolderManager.getInfo(elementId);
    }

    @Override
    public void updateCatalogFile(String folderId, File toUpdate) throws InternalException {
        File previousCatalogFile = null;
        try {
            WorkspaceFolderManager manager = new WorkspaceFolderManager(folderId);
            previousCatalogFile = manager.loadCatalogFile();
            String lockId = UUID.randomUUID().toString();
            manager.lock(lockId);
            manager.updateCatalogFile(toUpdate);
            manager.unlock(lockId);
        }
        catch (Throwable t) {
            log.warn("Unable to update catalogFile for {}. Trying to restore previous one..", (Object)folderId, (Object)t);
            throw new InternalException("Unable to restore previous catalog.", t);
        }
    }

    @Override
    public void shutDown() {
        log.trace("Cancelling processes...");
        for (Map.Entry<String, Process> entry : this.localProcesses.entrySet()) {
            entry.getValue().cancel();
        }
        log.trace("Shutting down services... ");
        this.initializationExecutor.shutdown();
        this.synchronizationExecutor.shutdown();
        do {
            log.trace("Waiting for services to terminate..");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.initializationExecutor.isTerminated() || !this.synchronizationExecutor.isTerminated());
        RequestLogger.get().close();
        log.trace("Terminated.");
    }

    @Override
    public void forceUnlock(String folderId) throws InternalException, WorkspaceInteractionException {
        log.warn("Forcing unlock of {} ", (Object)folderId);
        new WorkspaceFolderManager(folderId).forceUnlock();
    }

    @Override
    public ProcessDescriptor getProcessDescriptorByFolderId(String folderId) throws ProcessNotFoundException {
        if (!this.localProcesses.containsKey(folderId)) {
            throw new ProcessNotFoundException(folderId + " is not under processes or process is not in this host");
        }
        return this.localProcesses.get(folderId).getDescriptor();
    }

    @Override
    public ProcessStatus getProcessStatusByFolderId(String folderId) throws ProcessNotFoundException {
        if (!this.localProcesses.containsKey(folderId)) {
            throw new ProcessNotFoundException(folderId + " is not under processes or process is not in this host");
        }
        return this.localProcesses.get(folderId).getStatus();
    }

    @Override
    public Set<CatalogBean> getAvailableCatalogsByToken(String token) throws InternalException {
        ThreddsController controller = new ThreddsController("", token);
        ThreddsInfo info = controller.getThreddsInfo();
        HashSet<CatalogBean> toReturn = SynchEngineImpl.asCatalogBeanSet(info.getCatalog());
        DataSetScan mainScan = (DataSetScan)info.getCatalog().getDeclaredDataSetScan().iterator().next();
        CatalogBean defaultBean = new CatalogBean(mainScan.getName(), mainScan.getLocation(), true);
        toReturn.remove(defaultBean);
        toReturn.add(defaultBean);
        String threddsPersistencePath = info.getLocalBasePath();
        for (CatalogBean bean : toReturn) {
            String path = bean.getPath();
            if (path.startsWith(threddsPersistencePath)) {
                path = path.substring(threddsPersistencePath.length());
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            bean.setPath(path);
        }
        return toReturn;
    }

    private static HashSet<CatalogBean> asCatalogBeanSet(ThreddsCatalog catalog) {
        HashSet<CatalogBean> toReturn = new HashSet<CatalogBean>();
        for (DataSetScan scan : catalog.getDeclaredDataSetScan()) {
            toReturn.add(new CatalogBean(scan.getName(), scan.getLocation(), false));
        }
        if (catalog.getSubCatalogs() != null && catalog.getSubCatalogs().getLinkedCatalogs() != null) {
            for (ThreddsCatalog sub : catalog.getSubCatalogs().getLinkedCatalogs()) {
                toReturn.addAll(SynchEngineImpl.asCatalogBeanSet(sub));
            }
        }
        return toReturn;
    }

    @Override
    public SyncEngineStatusDescriptor getStatus() {
        ThreadPoolExecutor exec = (ThreadPoolExecutor)this.synchronizationExecutor;
        return new SyncEngineStatusDescriptor(exec.getActiveCount(), exec.getQueue().size(), LocalConfiguration.get().asMap());
    }
}

