/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl.threads;

import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.usecases.ws.thredds.engine.impl.Process;
import org.gcube.usecases.ws.thredds.engine.impl.ProcessDescriptor;
import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceFolderManager;
import org.gcube.usecases.ws.thredds.engine.impl.threads.ProcessIdProvider;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessInitializationThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessInitializationThread.class);
    @NonNull
    private Process theProcess;
    @NonNull
    private ExecutorService service;

    @Override
    public void run() {
        ProcessDescriptor descriptor = this.theProcess.getDescriptor();
        ProcessIdProvider.instance.set(descriptor.getProcessId());
        log.info("Initialization of process {} ", (Object)descriptor);
        this.theProcess.getStatus().setCurrentMessage("Gathering synchronization information...");
        try {
            WorkspaceFolderManager manager = new WorkspaceFolderManager(descriptor.getFolderId());
            log.debug("Updateing synchronization status..");
            manager.check(true);
            log.debug("Launching requests...");
            this.theProcess.launch(this.service);
        }
        catch (WorkspaceInteractionException e) {
            log.error("Unable to proceed..", (Throwable)e);
            this.theProcess.cancel();
        }
        catch (InternalException e) {
            log.error("Unable to proceed..", (Throwable)e);
            this.theProcess.cancel();
        }
        catch (StorageHubException e) {
            log.error("Unable to proceed..", (Throwable)e);
            this.theProcess.cancel();
        }
        catch (Throwable t) {
            log.error("Unexpected Error : ", t);
            this.theProcess.cancel();
        }
        finally {
            ProcessIdProvider.instance.reset();
        }
    }

    @NonNull
    public Process getTheProcess() {
        return this.theProcess;
    }

    @NonNull
    public ExecutorService getService() {
        return this.service;
    }

    public void setTheProcess(@NonNull Process theProcess) {
        if (theProcess == null) {
            throw new NullPointerException("theProcess");
        }
        this.theProcess = theProcess;
    }

    public void setService(@NonNull ExecutorService service) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.service = service;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessInitializationThread)) {
            return false;
        }
        ProcessInitializationThread other = (ProcessInitializationThread)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Process this$theProcess = this.getTheProcess();
        Process other$theProcess = other.getTheProcess();
        if (this$theProcess == null ? other$theProcess != null : !this$theProcess.equals(other$theProcess)) {
            return false;
        }
        ExecutorService this$service = this.getService();
        ExecutorService other$service = other.getService();
        return !(this$service == null ? other$service != null : !this$service.equals(other$service));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProcessInitializationThread;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Process $theProcess = this.getTheProcess();
        result = result * 59 + ($theProcess == null ? 0 : $theProcess.hashCode());
        ExecutorService $service = this.getService();
        result = result * 59 + ($service == null ? 0 : $service.hashCode());
        return result;
    }

    public String toString() {
        return "ProcessInitializationThread(theProcess=" + this.getTheProcess() + ", service=" + this.getService() + ")";
    }

    @ConstructorProperties(value={"theProcess", "service"})
    public ProcessInitializationThread(@NonNull Process theProcess, @NonNull ExecutorService service) {
        if (theProcess == null) {
            throw new NullPointerException("theProcess");
        }
        if (service == null) {
            throw new NullPointerException("service");
        }
        this.theProcess = theProcess;
        this.service = service;
    }
}

