package org.gcube.data.analysis.tabulardata.service.tabular.metadata;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="CreatedAt")
@XmlAccessorType(XmlAccessType.FIELD)
public class CreationDateMetadata implements TabularResourceMetadata {

	/**
	 * 
	 */
	private static final long serialVersionUID = 7076339378800854490L;

	Date value;

	@SuppressWarnings("unused")
	private CreationDateMetadata() {
	}

	public CreationDateMetadata(Date value) {
		this.value = value;
	}

	public Date getValue() {
		return value;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CreationDateMetadata other = (CreationDateMetadata) obj;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CreationDateMetadata [\n\tvalue=");
		builder.append(value);
		builder.append("\n]");
		return builder.toString();
	}

}
