/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.service.operation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.data.analysis.tabulardata.operation.worker.ActivityStatus;
import org.gcube.data.analysis.tabulardata.operation.worker.JobResult;
import org.gcube.data.analysis.tabulardata.operation.worker.OperationInvocation;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.gcube.data.analysis.tabulardata.service.operation.TaskJob;
import org.gcube.data.analysis.tabulardata.service.tabular.TabularResourceId;

public class ImmutableTask
implements Task {
    private Task.TaskId id;
    private OperationInvocation sourceOperationInvocation;
    private List<TaskJob> operationInstanceSteps;
    private JobResult operationResult;
    private float progress;
    private ActivityStatus status;
    private Date startTime;
    private Date endTime;
    private String invokerUsername;
    private List<TabularResourceId> collateralTabularResourceIds = new ArrayList<TabularResourceId>();

    public ImmutableTask(Task.TaskId id, OperationInvocation sourceOperationInvocation, List<TaskJob> jobs, JobResult operationResult, float progress, ActivityStatus status, Date startTime, Date endTime, String invokerUsername) {
        this.id = id;
        this.sourceOperationInvocation = sourceOperationInvocation;
        this.operationInstanceSteps = jobs;
        this.operationResult = operationResult;
        this.progress = progress;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.invokerUsername = invokerUsername;
    }

    public ImmutableTask(Task.TaskId id, OperationInvocation sourceOperationInvocation, List<TaskJob> operationInstanceSteps, JobResult operationResult, float progress, ActivityStatus status, Date startTime, Date endTime, String invokerUsername, List<TabularResourceId> collateralTabularResourceIds) {
        this.id = id;
        this.sourceOperationInvocation = sourceOperationInvocation;
        this.operationInstanceSteps = operationInstanceSteps;
        this.operationResult = operationResult;
        this.progress = progress;
        this.status = status;
        this.startTime = startTime;
        this.endTime = endTime;
        this.invokerUsername = invokerUsername;
        this.collateralTabularResourceIds = collateralTabularResourceIds;
    }

    @Override
    public Task.TaskId getId() {
        return this.id;
    }

    public OperationInvocation getSourceInvocation() {
        return this.sourceOperationInvocation;
    }

    public JobResult getResult() {
        return this.operationResult;
    }

    public float getProgress() {
        return this.progress;
    }

    public ActivityStatus getStatus() {
        return this.status;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getEndTime() {
        return this.endTime;
    }

    @Override
    public String getInvokerUsername() {
        return this.invokerUsername;
    }

    @Override
    public List<TaskJob> getTaskJobs() {
        return this.operationInstanceSteps;
    }

    @Override
    public List<TabularResourceId> getCollateralTabularResourceIds() {
        return ImmutableList.copyOf(this.collateralTabularResourceIds);
    }

    @Override
    public void abort() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ImmutableTask [id=");
        builder.append(this.id);
        builder.append(", sourceOperationInvocation=");
        builder.append(this.sourceOperationInvocation);
        builder.append(", operationInstanceSteps=");
        builder.append(this.operationInstanceSteps);
        builder.append(", operationResult=");
        builder.append(this.operationResult);
        builder.append(", progress=");
        builder.append(this.progress);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", startTime=");
        builder.append(this.startTime);
        builder.append(", endTime=");
        builder.append(this.endTime);
        builder.append(", invokerUsername=");
        builder.append(this.invokerUsername);
        builder.append("]");
        return builder.toString();
    }
}

