/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.textextraction;

import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.SrvType;
import org.gcube.textextraction.ServiceContext;
import org.gcube.textextraction.exceptions.JobStatusRetrievalException;
import org.gcube.textextraction.exceptions.NoScriptFoundException;
import org.gcube.textextraction.exceptions.NoWorkflowEngineEPRFound;
import org.gcube.textextraction.exceptions.NodeWithTextExtractionSoftwareNotFoundException;
import org.gcube.textextraction.exceptions.WorkflowEnginePortTypeException;
import org.gcube.textextraction.stubs.Cancel;
import org.gcube.textextraction.stubs.CancelResponse;
import org.gcube.textextraction.stubs.JobInfoType;
import org.gcube.textextraction.stubs.Start;
import org.gcube.textextraction.stubs.StartResponse;
import org.gcube.textextraction.utils.JobSubmissionUtils;
import org.gcube.textextraction.utils.ServiceUtils;

public class TextExtractionJobControllerResource
extends GCUBEWSResource {
    static GCUBELog logger = new GCUBELog(TextExtractionJobControllerResource.class);
    public static final String RP_REPOSITORY_ID = "RepositoryID";
    public static final String RP_JOBS = "Jobs";
    public static final String RP_QUERY_TO_SUBMIT = "QueryToSubmit";
    public static final String RP_DTS_INPUT_COLLECTION_ID = "DTSInputCollectionID";
    public static final String RP_STATUS = "Status";
    public static final String RP_SERVLET_URI = "ServletURI";
    public static final String RP_FTP_LOCATION_DIRECTORY = "FTPLocationDirectory";
    public static final String RP_REPOSITORY_NUMBER_OF_RECORDS = "RepositoryNumberOfRecords";
    public static final String RP_NUMBER_OF_COMPLETED_JOBS = "NumberOfCompletedJobs";
    public static final String RP_FTP_HOST = "FTPHost";
    public static final String RP_BATCHSIZE = "BatchSize";
    private static final Object STATUS_NOTSTARTED = "NOTSTARTED";
    protected static String[] RPNames = new String[]{"RepositoryID", "Jobs", "QueryToSubmit", "DTSInputCollectionID", "Status", "ServletURI", "FTPLocationDirectory", "RepositoryNumberOfRecords", "NumberOfCompletedJobs", "FTPHost", "BatchSize"};
    protected Thread thread;
    protected boolean bInitializing;

    public String[] getPropertyNames() {
        return RPNames;
    }

    public boolean isInitializing() {
        return this.bInitializing;
    }

    public void setIsInitializing(boolean isInitializing) {
        this.bInitializing = isInitializing;
    }

    protected void initialise(Object ... args) throws Exception {
        logger.debug((Object)"initialise is called!");
        this.setIsInitializing(true);
        GCUBEWSResourceKey key = (GCUBEWSResourceKey)args[0];
        String repositoryID = (String)args[1];
        String servletURI = (String)args[2];
        String dtsInputCollectionID = (String)args[3];
        String ftpLocation = (String)args[4];
        String queryToSubmit = (String)args[5];
        int repositoryNumberOfRecords = (Integer)args[6];
        String ftpHost = (String)args[7];
        int batchSize = (Integer)args[8];
        int numberOfCompletedJobs = 0;
        this.getResourcePropertySet().get(RP_REPOSITORY_ID).clear();
        this.getResourcePropertySet().get(RP_REPOSITORY_ID).add((Object)repositoryID);
        logger.debug((Object)("Just added to the resource property set RP_REPOSITORY_ID: " + this.getResourcePropertySet().get(RP_REPOSITORY_ID).get(0)));
        this.getResourcePropertySet().get(RP_SERVLET_URI).clear();
        this.getResourcePropertySet().get(RP_SERVLET_URI).add((Object)servletURI);
        logger.debug((Object)("Just added to the resource property set RP_SERVLET_URI: " + this.getResourcePropertySet().get(RP_SERVLET_URI).get(0)));
        this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).clear();
        this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).add((Object)dtsInputCollectionID);
        logger.debug((Object)("Just added to the resource property set RP_DTS_INPUT_COLLECTION_ID: " + this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).get(0)));
        this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).clear();
        this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).add((Object)ftpLocation);
        logger.debug((Object)("Just added to the resource property set RP_FTP_LOCATION_DIRECTORY: " + this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).get(0)));
        this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).clear();
        this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).add((Object)queryToSubmit);
        logger.debug((Object)("Just added to the resource property set RP_QUERY_TO_SUBMIT: " + this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).get(0)));
        this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).clear();
        this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).add((Object)repositoryNumberOfRecords);
        logger.debug((Object)("Just added to the resource property set RP_REPOSITORY_NUMBER_OF_RECORDS: " + this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).get(0)));
        this.getResourcePropertySet().get(RP_STATUS).clear();
        this.getResourcePropertySet().get(RP_STATUS).add(STATUS_NOTSTARTED);
        JobInfoType[] jobs = new JobInfoType[]{};
        this.getResourcePropertySet().get(RP_JOBS).clear();
        this.getResourcePropertySet().get(RP_JOBS).add((Object)jobs);
        this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).clear();
        this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).add((Object)numberOfCompletedJobs);
        this.getResourcePropertySet().get(RP_FTP_HOST).clear();
        this.getResourcePropertySet().get(RP_FTP_HOST).add((Object)ftpHost);
        logger.debug((Object)("Just added to the resource property set RP_FTP_HOST: " + this.getResourcePropertySet().get(RP_FTP_HOST).get(0)));
        this.getResourcePropertySet().get(RP_BATCHSIZE).clear();
        this.getResourcePropertySet().get(RP_BATCHSIZE).add((Object)batchSize);
        logger.debug((Object)("Just added to the resource property set RP_BATCHSIZE: " + this.getResourcePropertySet().get(RP_BATCHSIZE).get(0)));
        this.setIsInitializing(false);
        logger.debug((Object)"initialise returned!");
    }

    protected void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        try {
            logger.debug((Object)"OnLoad started!");
            this.setIsInitializing(true);
            String scope = (String)this.getResourcePropertySet().getScope().get(0);
            logger.debug((Object)("Loaded scope: " + scope));
            this.getServiceContext().setScope(GCUBEScope.getScope((String)scope));
            String repositoryID = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_REPOSITORY_ID).clear();
            this.getResourcePropertySet().get(RP_REPOSITORY_ID).add((Object)repositoryID);
            int size = ois.readInt();
            JobInfoType[] jobs = new JobInfoType[size];
            for (int i = 0; i < size; ++i) {
                jobs[i].setJobID((String)ois.readObject());
                jobs[i].setJobStatus((String)ois.readObject());
                jobs[i].setBatchRangeStart(ois.readInt());
                jobs[i].setBatchRangeEnd(ois.readInt());
                jobs[i].setEngineURL((String)ois.readObject());
                jobs[i].setSubmissionAttemptNo(ois.readInt());
            }
            this.getResourcePropertySet().get(RP_JOBS).clear();
            this.getResourcePropertySet().get(RP_JOBS).add((Object)jobs);
            String queryToSubmit = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).clear();
            this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).add((Object)queryToSubmit);
            String status = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_STATUS).clear();
            this.getResourcePropertySet().get(RP_STATUS).add((Object)status);
            String servletURI = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_SERVLET_URI).clear();
            this.getResourcePropertySet().get(RP_SERVLET_URI).add((Object)servletURI);
            String ftpLocationDirectory = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).clear();
            this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).add((Object)ftpLocationDirectory);
            String dtsInputCollectionID = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).clear();
            this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).add((Object)dtsInputCollectionID);
            int repostitoryNumberOfRecords = (Integer)ois.readObject();
            this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).clear();
            this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).add((Object)repostitoryNumberOfRecords);
            int numberOfCompletedJobs = (Integer)ois.readObject();
            this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).clear();
            this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).add((Object)numberOfCompletedJobs);
            String ftpHost = (String)ois.readObject();
            this.getResourcePropertySet().get(RP_FTP_HOST).clear();
            this.getResourcePropertySet().get(RP_FTP_HOST).add((Object)ftpHost);
            int batchSize = (Integer)ois.readObject();
            this.getResourcePropertySet().get(RP_BATCHSIZE).clear();
            this.getResourcePropertySet().get(RP_BATCHSIZE).add((Object)batchSize);
            this.setIsInitializing(false);
            logger.debug((Object)"OnLoad finished!");
        }
        catch (Exception e) {
            logger.error((Object)"Caught exception during OnLoad", (Throwable)e);
            throw e;
        }
    }

    protected void onStore(ObjectOutputStream oos) throws Exception {
        logger.debug((Object)"OnStore started!");
        oos.writeObject((String)this.getResourcePropertySet().get(RP_REPOSITORY_ID).get(0));
        JobInfoType[] jobs = (JobInfoType[])this.getResourcePropertySet().get(RP_JOBS).get(0);
        oos.writeInt(jobs.length);
        logger.debug((Object)("Just wrote jobIDs size= " + jobs.length));
        for (int i = 0; i < jobs.length; ++i) {
            oos.writeObject(jobs[i].getJobID());
            oos.writeObject(jobs[i].getJobStatus());
            oos.writeInt(jobs[i].getBatchRangeStart());
            oos.writeInt(jobs[i].getBatchRangeEnd());
            oos.writeObject(jobs[i].getEngineURL());
            oos.writeInt(jobs[i].getSubmissionAttemptNo());
        }
        oos.writeObject((String)this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_STATUS).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_SERVLET_URI).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).get(0));
        oos.writeObject((Integer)this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).get(0));
        oos.writeObject((Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_FTP_HOST).get(0));
        oos.writeObject((Integer)this.getResourcePropertySet().get(RP_BATCHSIZE).get(0));
        logger.debug((Object)"OnStore finished!");
    }

    public void store() {
        if (!this.isInitializing()) {
            super.store();
        }
    }

    public String getRepositoryID() {
        return (String)this.getResourcePropertySet().get(RP_REPOSITORY_ID).get(0);
    }

    public void setRepositoryID(String repositoryID) {
        this.getResourcePropertySet().get(RP_REPOSITORY_ID).clear();
        this.getResourcePropertySet().get(RP_REPOSITORY_ID).add((Object)repositoryID);
    }

    public JobInfoType[] getJobs() {
        return (JobInfoType[])this.getResourcePropertySet().get(RP_JOBS).get(0);
    }

    public void setJobs(JobInfoType[] jobs) {
        this.getResourcePropertySet().get(RP_JOBS).set(0, (Object)jobs);
    }

    public String getDTSInputCollectionID() {
        return (String)this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).get(0);
    }

    public void setDTSInputCollectionID(String dtsInputCollectionID) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).clear();
            this.getResourcePropertySet().get(RP_DTS_INPUT_COLLECTION_ID).add((Object)dtsInputCollectionID);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public String getFTPLocationDirectory() {
        return (String)this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).get(0);
    }

    public String getFTPHost() {
        return (String)this.getResourcePropertySet().get(RP_FTP_HOST).get(0);
    }

    public int getBatchSize() {
        return (Integer)this.getResourcePropertySet().get(RP_BATCHSIZE).get(0);
    }

    public void setFTPLocationDirectory(String ftpLocationDirectory) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).clear();
            this.getResourcePropertySet().get(RP_FTP_LOCATION_DIRECTORY).add((Object)ftpLocationDirectory);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void setBatchSize(int bs) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_BATCHSIZE).clear();
            this.getResourcePropertySet().get(RP_BATCHSIZE).add((Object)bs);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public void setFTPHost(String ftpHostAddress) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_FTP_HOST).clear();
            this.getResourcePropertySet().get(RP_FTP_HOST).add((Object)ftpHostAddress);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public int getRepositoryNumberOfRecords() {
        return (Integer)this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).get(0);
    }

    public void setRepositoryNumberOfRecords(int repositoryNumberOfRecords) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).clear();
            this.getResourcePropertySet().get(RP_REPOSITORY_NUMBER_OF_RECORDS).add((Object)repositoryNumberOfRecords);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public int getNumberOfCompletedJobs() {
        return (Integer)this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).get(0);
    }

    public void setNumberOfCompletedJobs(int numberOfCompletedJobs) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).clear();
            this.getResourcePropertySet().get(RP_NUMBER_OF_COMPLETED_JOBS).add((Object)numberOfCompletedJobs);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public String getQueryToSubmit() {
        return (String)this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).get(0);
    }

    public void setQueryToSubmit(String queryToSubmit) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).clear();
            this.getResourcePropertySet().get(RP_QUERY_TO_SUBMIT).add((Object)queryToSubmit);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public String getServletURI() {
        return (String)this.getResourcePropertySet().get(RP_SERVLET_URI).get(0);
    }

    public void setServletURI(String servletURI) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_SERVLET_URI).clear();
            this.getResourcePropertySet().get(RP_SERVLET_URI).add((Object)servletURI);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public String getStatus() {
        return (String)this.getResourcePropertySet().get(RP_STATUS).get(0);
    }

    public void setStatus(String status) throws Exception {
        try {
            this.getResourcePropertySet().get(RP_STATUS).clear();
            this.getResourcePropertySet().get(RP_STATUS).add((Object)status);
        }
        catch (Exception e) {
            logger.error((Object)e.toString(), (Throwable)e);
        }
    }

    public StartResponse start(Start start) throws RemoteException {
        logger.debug((Object)("INSIDE START: scope is: " + this.getServiceContext().getScope().toString() + " " + start.getFTPUser() + " " + start.getNumberOfExecutionNodes() + " " + start.getWaitingPeriodMillis()));
        try {
            ServiceUtils.Init(this.getServiceContext().getScope().toString());
        }
        catch (EnvironmentValidationException e) {
            logger.error((Object)"Error while initialising Environment Validation", (Throwable)e);
        }
        String user = start.getFTPUser();
        String pass = start.getFTPPassword();
        String port = start.getFTPPort();
        String scope = this.getServiceContext().getScope().toString();
        int numberOfNodes = Integer.parseInt(start.getNumberOfExecutionNodes());
        long waitingTimeMillis = Long.parseLong(start.getWaitingPeriodMillis());
        this.thread = new JobsPollingThread(scope, user, pass, port, numberOfNodes, waitingTimeMillis);
        this.thread.setDaemon(true);
        this.thread.start();
        return new StartResponse();
    }

    public CancelResponse cancel(Cancel cancel) throws RemoteException {
        try {
            this.setStatus("CANCELLED");
        }
        catch (Exception e) {
            logger.error((Object)"Error while setting status to resource", (Throwable)e);
        }
        return new CancelResponse();
    }

    public GCUBEServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public void onResourceRemoval() {
    }

    protected class JobsPollingThread
    extends Thread {
        String scope = new String();
        String username = "anonymous";
        String port = new String();
        String password = new String();
        int numberOfNodes = 5;
        long waitingTimeMillis;

        public JobsPollingThread(String scope, String username, String password, String port, int numberOfNodes, long timeMillis) {
            this.scope = scope;
            this.username = username;
            this.password = password;
            this.port = port;
            this.numberOfNodes = numberOfNodes;
            this.waitingTimeMillis = timeMillis;
        }

        @Override
        public void run() {
            HashMap<String, Long> dtsEprsMap = new HashMap<String, Long>();
            HashMap<String, Long> ocrEprsMap = new HashMap<String, Long>();
            int nodesDifference = 0;
            int keepDifference = 0;
            boolean numberOfNodesChanged = false;
            boolean moreNodes = false;
            int batchSize = TextExtractionJobControllerResource.this.getBatchSize();
            logger.debug((Object)"New Thread created!");
            logger.debug((Object)("The status read is: " + TextExtractionJobControllerResource.this.getStatus()));
            if (!TextExtractionJobControllerResource.this.getStatus().equals("COMPLETED")) {
                String servletURI = TextExtractionJobControllerResource.this.getServletURI();
                String ftpHost = TextExtractionJobControllerResource.this.getFTPHost();
                String ftpFolder = TextExtractionJobControllerResource.this.getFTPLocationDirectory();
                String dtsInputCollectionId = TextExtractionJobControllerResource.this.getDTSInputCollectionID();
                String defaultQuery = TextExtractionJobControllerResource.this.getQueryToSubmit();
                String ftpUser = this.username;
                String ftpPassword = this.password;
                String ftpPort = this.port;
                String[] dtsEPRs = null;
                String[] ocrEPRs = null;
                if (TextExtractionJobControllerResource.this.getStatus().equals("NOTSTARTED")) {
                    Long curTime;
                    try {
                        logger.debug((Object)("The SCOPE is: " + this.scope));
                        dtsEPRs = ServiceUtils.getEPRsForService("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name(), this.scope);
                    }
                    catch (GCUBEScope.MalformedScopeExpressionException e) {
                        logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
                    }
                    if (dtsEPRs != null) {
                        for (int d = 0; d < dtsEPRs.length; ++d) {
                            curTime = System.currentTimeMillis();
                            dtsEprsMap.put(dtsEPRs[d], curTime);
                        }
                    }
                    try {
                        ocrEPRs = ServiceUtils.getEPRsForService("Execution", "OCRService", SrvType.FACTORY.name(), this.scope);
                    }
                    catch (GCUBEScope.MalformedScopeExpressionException e) {
                        logger.error((Object)"Error while retrieving EPRs for OCR", (Throwable)e);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while retrieving EPRs for OCR", (Throwable)e);
                    }
                    if (ocrEPRs != null) {
                        for (int d = 0; d < ocrEPRs.length; ++d) {
                            curTime = System.currentTimeMillis();
                            ocrEprsMap.put(ocrEPRs[d], curTime);
                        }
                    }
                    logger.debug((Object)"Initial call - creating jobs");
                    int startIndexBatch = 0;
                    int endIndexBatch = startIndexBatch + batchSize;
                    int startIndexPage = 1;
                    JobInfoType[] jobsArray = null;
                    ArrayList<JobInfoType> runningJobsList = new ArrayList<JobInfoType>();
                    int n = 0;
                    int m = 0;
                    for (int i = 0; i < this.numberOfNodes; ++i) {
                        String dtsSuggestion = new String();
                        String ocrSuggestion = new String();
                        if (dtsEPRs != null && n < dtsEPRs.length) {
                            dtsSuggestion = dtsEPRs[n];
                            ++n;
                        } else if (dtsEPRs != null && dtsEPRs.length >= 1) {
                            n = 0;
                            dtsSuggestion = dtsEPRs[0];
                        }
                        if (ocrEPRs != null && m < ocrEPRs.length) {
                            ocrSuggestion = ocrEPRs[m];
                            ++m;
                        } else if (ocrEPRs != null && ocrEPRs.length >= 1) {
                            m = 0;
                            ocrSuggestion = ocrEPRs[0];
                        }
                        logger.debug((Object)("DTSSuggestion is: " + dtsSuggestion));
                        dtsEprsMap.put(dtsSuggestion, System.currentTimeMillis());
                        logger.debug((Object)("OCRSuggestion is: " + ocrSuggestion));
                        ocrEprsMap.put(ocrSuggestion, System.currentTimeMillis());
                        String startBString = Integer.toString(startIndexPage);
                        String endBString = Integer.toString(batchSize);
                        String halfQuery = defaultQuery.replace("startPage", startBString);
                        String queryToSubmit = halfQuery.replaceAll("size", endBString);
                        logger.debug((Object)("The QueryToSubmit is: " + queryToSubmit));
                        String jId = new String();
                        ArrayList<String> engineUrl = new ArrayList<String>();
                        try {
                            jId = JobSubmissionUtils.createAndSubmitJob(servletURI, queryToSubmit, ftpHost, ftpFolder, this.scope, dtsInputCollectionId, ftpUser, ftpPassword, ftpPort, dtsSuggestion, ocrSuggestion, engineUrl);
                        }
                        catch (EnvironmentInformationSystemException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (NoScriptFoundException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            return;
                        }
                        catch (IOException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (NodeWithTextExtractionSoftwareNotFoundException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (NoWorkflowEngineEPRFound e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (WorkflowEnginePortTypeException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        JobInfoType newJob = new JobInfoType();
                        newJob.setJobID(jId);
                        newJob.setBatchRangeStart(startIndexBatch);
                        newJob.setBatchRangeEnd(endIndexBatch);
                        newJob.setJobStatus("RUNNING");
                        newJob.setEngineURL(engineUrl.get(0));
                        newJob.setSubmissionAttemptNo(1);
                        startIndexBatch += batchSize;
                        endIndexBatch += batchSize;
                        ++startIndexPage;
                        runningJobsList.add(newJob);
                        logger.debug((Object)"Created a Job!");
                        if (startIndexBatch >= TextExtractionJobControllerResource.this.getRepositoryNumberOfRecords()) break;
                    }
                    if (runningJobsList.size() > 0) {
                        jobsArray = new JobInfoType[runningJobsList.size()];
                        for (int j = 0; j < jobsArray.length; ++j) {
                            jobsArray[j] = (JobInfoType)runningJobsList.get(j);
                        }
                        logger.debug((Object)"Adding jobs to resource!");
                        TextExtractionJobControllerResource.this.setJobs(jobsArray);
                        try {
                            TextExtractionJobControllerResource.this.setStatus("RUNNING");
                        }
                        catch (Exception e) {
                            logger.error((Object)"An error occured while seting status to JOB", (Throwable)e);
                        }
                    }
                } else if (TextExtractionJobControllerResource.this.getStatus().equals("CANCELLED")) {
                    try {
                        Long curTime;
                        TextExtractionJobControllerResource.this.setStatus("RUNNING");
                        JobInfoType[] runningJobs = TextExtractionJobControllerResource.this.getJobs();
                        int noRunningJobs = runningJobs.length;
                        logger.debug((Object)("Comparing  number of nodes: " + noRunningJobs + " " + this.numberOfNodes));
                        if (noRunningJobs > this.numberOfNodes) {
                            numberOfNodesChanged = true;
                            moreNodes = false;
                            keepDifference = nodesDifference = noRunningJobs - this.numberOfNodes;
                        } else if (noRunningJobs < this.numberOfNodes) {
                            numberOfNodesChanged = true;
                            moreNodes = true;
                            nodesDifference = this.numberOfNodes - noRunningJobs;
                        } else {
                            numberOfNodesChanged = false;
                        }
                        try {
                            logger.debug((Object)("The SCOPE is: " + this.scope));
                            dtsEPRs = ServiceUtils.getEPRsForService("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name(), this.scope);
                        }
                        catch (GCUBEScope.MalformedScopeExpressionException e) {
                            logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
                        }
                        if (dtsEPRs != null) {
                            for (int d = 0; d < dtsEPRs.length; ++d) {
                                curTime = System.currentTimeMillis();
                                dtsEprsMap.put(dtsEPRs[d], curTime);
                            }
                        }
                        try {
                            ocrEPRs = ServiceUtils.getEPRsForService("Execution", "OCRService", SrvType.FACTORY.name(), this.scope);
                        }
                        catch (GCUBEScope.MalformedScopeExpressionException e) {
                            logger.error((Object)"Error while retrieving EPRs for OCR", (Throwable)e);
                        }
                        catch (Exception e) {
                            logger.error((Object)"Error while retrieving EPRs for OCR", (Throwable)e);
                        }
                        if (ocrEPRs != null) {
                            for (int d = 0; d < ocrEPRs.length; ++d) {
                                curTime = System.currentTimeMillis();
                                ocrEprsMap.put(ocrEPRs[d], curTime);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while setting status to resource", (Throwable)e);
                    }
                }
                while (true) {
                    String jId;
                    String halfQuery;
                    try {
                        Thread.sleep(this.waitingTimeMillis);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e);
                        logger.debug((Object)(new Date(System.currentTimeMillis()) + " jobs Polling thread was interrupted (in polling thread)"));
                        return;
                    }
                    if (TextExtractionJobControllerResource.this.getStatus().equals("CANCELLED")) {
                        return;
                    }
                    logger.debug((Object)"\n");
                    logger.debug((Object)"\n");
                    logger.debug((Object)"************************* STATUS CHECK ***************************");
                    logger.debug((Object)"\n");
                    logger.debug((Object)"\n");
                    JobInfoType[] jobsArray = null;
                    ArrayList<JobInfoType> runningJobsList = new ArrayList<JobInfoType>();
                    JobInfoType[] runningJobs = TextExtractionJobControllerResource.this.getJobs();
                    if (runningJobs == null || runningJobs.length == 0) {
                        try {
                            TextExtractionJobControllerResource.this.setStatus("COMPLETED");
                        }
                        catch (Exception e) {
                            logger.debug((Object)"An error occured while setting status to JOB", (Throwable)e);
                        }
                        return;
                    }
                    logger.debug((Object)("NUMBER OF SUBMITTED JOBs: " + runningJobs.length));
                    for (int i = 0; i < runningJobs.length; ++i) {
                        String executionId = runningJobs[i].getJobID();
                        String engineUrl = runningJobs[i].getEngineURL();
                        int numberOfSubmissions = runningJobs[i].getSubmissionAttemptNo();
                        String status = new String();
                        try {
                            status = JobSubmissionUtils.getJobStatus(executionId, this.scope, engineUrl);
                        }
                        catch (WorkflowEnginePortTypeException e1) {
                            logger.error((Object)("Error while retrieving status for job: " + executionId + " endpoint: " + engineUrl), (Throwable)e1);
                            if (numberOfSubmissions < 3) {
                                status = "TORESUBMIT";
                            } else {
                                logger.debug((Object)"Job has been submitted more than 3 times. It will be omitted");
                                logger.debug((Object)("Batch Range: " + runningJobs[i].getBatchRangeStart() + " " + runningJobs[i].getBatchRangeEnd()));
                                status = "COMPLETED";
                            }
                        }
                        catch (JobStatusRetrievalException e1) {
                            logger.error((Object)("Error while retrieving status for job: " + executionId + " endpoint: " + engineUrl), (Throwable)e1);
                            if (numberOfSubmissions < 3) {
                                status = "TORESUBMIT";
                            }
                            logger.debug((Object)"Job has been submitted more than 3 times. It will be omitted");
                            logger.debug((Object)("Batch Range: " + runningJobs[i].getBatchRangeStart() + " " + runningJobs[i].getBatchRangeEnd()));
                            status = "COMPLETED";
                        }
                        logger.debug((Object)("CHECKING JOB STATUS: " + executionId + " " + status));
                        if (status.equals("TORESUBMIT")) {
                            if (numberOfSubmissions > 3) {
                                logger.debug((Object)"Number of Submissions greater than 3! Omitting job!");
                                continue;
                            }
                            int batchS = runningJobs[i].getBatchRangeStart();
                            int batchE = runningJobs[i].getBatchRangeEnd();
                            int noSubmissions = runningJobs[i].getSubmissionAttemptNo();
                            int startPage = batchS / batchSize;
                            String theQuery = TextExtractionJobControllerResource.this.getQueryToSubmit();
                            halfQuery = theQuery.replaceAll("size", Integer.toString(batchSize));
                            String toSubmit = halfQuery.replace("startPage", Integer.toString(++startPage));
                            jId = new String();
                            ArrayList<String> engineUrlList = new ArrayList<String>();
                            try {
                                String dts = this.getDTSSuggestion(dtsEprsMap, dtsEPRs);
                                String ocr = this.getOCRSuggestion(ocrEprsMap, ocrEPRs);
                                jId = JobSubmissionUtils.createAndSubmitJob(servletURI, toSubmit, ftpHost, ftpFolder, this.scope, dtsInputCollectionId, ftpUser, ftpPassword, ftpPort, dts, ocr, engineUrlList);
                            }
                            catch (EnvironmentInformationSystemException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + batchS + " " + batchE));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (NoScriptFoundException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + batchS + " " + batchE));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                return;
                            }
                            catch (IOException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + batchS + " " + batchE));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (NodeWithTextExtractionSoftwareNotFoundException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + batchS + " " + batchE));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (NoWorkflowEngineEPRFound e) {
                                logger.error((Object)("Problem while submitting job with batch: " + batchS + " " + batchE));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (WorkflowEnginePortTypeException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + batchS + " " + batchE));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            JobInfoType newJob = new JobInfoType();
                            newJob.setJobID(jId);
                            newJob.setBatchRangeStart(runningJobs[i].getBatchRangeStart());
                            newJob.setBatchRangeEnd(runningJobs[i].getBatchRangeEnd());
                            newJob.setJobStatus("RUNNING");
                            int noSub = noSubmissions + 1;
                            newJob.setSubmissionAttemptNo(noSub);
                            newJob.setEngineURL(engineUrlList.get(0));
                            logger.debug((Object)"RESUBMITTING JOB ");
                            runningJobsList.add(newJob);
                            continue;
                        }
                        if (!status.equals("COMPLETED")) {
                            JobInfoType newJob = new JobInfoType();
                            newJob.setJobID(runningJobs[i].getJobID());
                            newJob.setBatchRangeStart(runningJobs[i].getBatchRangeStart());
                            newJob.setBatchRangeEnd(runningJobs[i].getBatchRangeEnd());
                            newJob.setJobStatus("RUNNING");
                            newJob.setSubmissionAttemptNo(runningJobs[i].getSubmissionAttemptNo());
                            newJob.setEngineURL(runningJobs[i].getEngineURL());
                            logger.debug((Object)"STATUS STILL RUNNING - keeping the job");
                            runningJobsList.add(newJob);
                            continue;
                        }
                        logger.debug((Object)"STATUS COMPLETED - replacing the job?");
                        if (numberOfNodesChanged && !moreNodes && nodesDifference != 0) {
                            logger.debug((Object)("Less nodes available - Won't be replacing job! The nodes difference is: " + nodesDifference));
                            --nodesDifference;
                            int maxNo = TextExtractionJobControllerResource.this.getNumberOfCompletedJobs() + 1;
                            logger.debug((Object)("Number of Completed jobs: " + maxNo));
                            int noTF = maxNo * batchSize;
                            logger.debug((Object)("Number of transformed files: " + noTF));
                            try {
                                TextExtractionJobControllerResource.this.setNumberOfCompletedJobs(maxNo);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Error occured while writing number of completed jobs to Resource", (Throwable)e);
                            }
                            continue;
                        }
                        logger.debug((Object)"Replacement!");
                        int startingPage = TextExtractionJobControllerResource.this.getNumberOfCompletedJobs() + runningJobs.length + 1 - keepDifference;
                        int batchRangeStart = (startingPage - 1) * batchSize;
                        int batchRangeEnd = batchRangeStart + batchSize;
                        if (batchRangeStart >= TextExtractionJobControllerResource.this.getRepositoryNumberOfRecords()) {
                            logger.debug((Object)"STATUS COMPLETED - ALL JOBS HAVE BEEN SUBMITTED - RETURNING...");
                            int maxNo = TextExtractionJobControllerResource.this.getNumberOfCompletedJobs() + 1;
                            logger.debug((Object)("Number of Completed jobs: " + maxNo));
                            int noTF = maxNo * batchSize;
                            logger.debug((Object)("Number of transformed files: " + noTF));
                            try {
                                TextExtractionJobControllerResource.this.setNumberOfCompletedJobs(maxNo);
                            }
                            catch (Exception e) {
                                logger.error((Object)"Error occured while writing number of completed jobs to Resource", (Throwable)e);
                            }
                            try {
                                TextExtractionJobControllerResource.this.setStatus("COMPLETED");
                            }
                            catch (Exception e) {
                                logger.error((Object)"Error occured while setting Status to the resource.", (Throwable)e);
                            }
                            continue;
                        }
                        String dtsSuggestion = this.getDTSSuggestion(dtsEprsMap, dtsEPRs);
                        logger.debug((Object)("DTSSuggestion is: " + dtsSuggestion));
                        String ocrSuggestion = this.getOCRSuggestion(ocrEprsMap, ocrEPRs);
                        logger.debug((Object)("OCRSuggestion is: " + ocrSuggestion));
                        String startBString = Integer.toString(batchRangeStart);
                        String endBString = Integer.toString(batchRangeEnd);
                        String halfQuery2 = defaultQuery.replace("startPage", Integer.toString(startingPage));
                        String queryToSubmit = halfQuery2.replace("size", Integer.toString(batchSize));
                        logger.debug((Object)("The QueryToSubmit is: " + queryToSubmit));
                        String jId2 = new String();
                        ArrayList<String> engineUrlToFill = new ArrayList<String>();
                        try {
                            jId2 = JobSubmissionUtils.createAndSubmitJob(servletURI, queryToSubmit, ftpHost, ftpFolder, this.scope, dtsInputCollectionId, ftpUser, ftpPassword, ftpPort, dtsSuggestion, ocrSuggestion, engineUrlToFill);
                        }
                        catch (EnvironmentInformationSystemException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (NoScriptFoundException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            return;
                        }
                        catch (IOException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (NodeWithTextExtractionSoftwareNotFoundException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (NoWorkflowEngineEPRFound e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        catch (WorkflowEnginePortTypeException e) {
                            logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                            logger.error((Object)"Job omitted!", (Throwable)e);
                            continue;
                        }
                        String jobId = jId2;
                        JobInfoType newJob = new JobInfoType();
                        newJob.setJobID(jobId);
                        newJob.setBatchRangeStart(batchRangeStart);
                        newJob.setBatchRangeEnd(batchRangeEnd);
                        newJob.setJobStatus("RUNNING");
                        newJob.setEngineURL(engineUrlToFill.get(0));
                        newJob.setSubmissionAttemptNo(1);
                        runningJobsList.add(newJob);
                        int maxNo = TextExtractionJobControllerResource.this.getNumberOfCompletedJobs() + 1;
                        logger.debug((Object)("Number of Completed jobs: " + maxNo));
                        int noTF = maxNo * batchSize;
                        logger.debug((Object)("Number of transformed files: " + noTF));
                        try {
                            TextExtractionJobControllerResource.this.setNumberOfCompletedJobs(maxNo);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)"Error occured while writing number of completed jobs to Resource", (Throwable)e);
                        }
                    }
                    if (numberOfNodesChanged && moreNodes) {
                        logger.debug((Object)"Now we have more nodes!!");
                        int n = 0;
                        int m = 0;
                        int startingPage = TextExtractionJobControllerResource.this.getNumberOfCompletedJobs() + runningJobs.length + 1;
                        for (int i = 0; i < nodesDifference; ++i) {
                            int batchRangeStart = (startingPage - 1) * batchSize;
                            int batchRangeEnd = batchRangeStart + batchSize;
                            if (batchRangeStart >= TextExtractionJobControllerResource.this.getRepositoryNumberOfRecords()) break;
                            String dtsSuggestion = new String();
                            String ocrSuggestion = new String();
                            if (dtsEPRs != null && n < dtsEPRs.length) {
                                dtsSuggestion = dtsEPRs[n];
                                ++n;
                            } else if (dtsEPRs != null && dtsEPRs.length >= 1) {
                                n = 0;
                                dtsSuggestion = dtsEPRs[0];
                            }
                            if (ocrEPRs != null && m < ocrEPRs.length) {
                                ocrSuggestion = ocrEPRs[m];
                                ++m;
                            } else if (ocrEPRs != null && ocrEPRs.length >= 1) {
                                m = 0;
                                ocrSuggestion = ocrEPRs[0];
                            }
                            dtsEprsMap.put(dtsSuggestion, System.currentTimeMillis());
                            ocrEprsMap.put(ocrSuggestion, System.currentTimeMillis());
                            logger.debug((Object)("DTSSuggestion is: " + dtsSuggestion));
                            logger.debug((Object)("OCRSuggestion is: " + ocrSuggestion));
                            String startBString = Integer.toString(batchRangeStart);
                            String endBString = Integer.toString(batchRangeEnd);
                            halfQuery = defaultQuery.replace("startPage", Integer.toString(startingPage));
                            String queryToSubmit = halfQuery.replace("size", Integer.toString(batchSize));
                            logger.debug((Object)("The QueryToSubmit is: " + queryToSubmit));
                            jId = new String();
                            ArrayList<String> engineUrlToFill = new ArrayList<String>();
                            try {
                                jId = JobSubmissionUtils.createAndSubmitJob(servletURI, queryToSubmit, ftpHost, ftpFolder, this.scope, dtsInputCollectionId, ftpUser, ftpPassword, ftpPort, dtsSuggestion, ocrSuggestion, engineUrlToFill);
                            }
                            catch (EnvironmentInformationSystemException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (NoScriptFoundException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                return;
                            }
                            catch (IOException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (NodeWithTextExtractionSoftwareNotFoundException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (NoWorkflowEngineEPRFound e) {
                                logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            catch (WorkflowEnginePortTypeException e) {
                                logger.error((Object)("Problem while submitting job with batch: " + startBString + " " + endBString));
                                logger.error((Object)"Job omitted!", (Throwable)e);
                                continue;
                            }
                            String jobId = jId;
                            JobInfoType newJob = new JobInfoType();
                            newJob.setJobID(jobId);
                            newJob.setBatchRangeStart(batchRangeStart);
                            newJob.setBatchRangeEnd(batchRangeEnd);
                            newJob.setJobStatus("RUNNING");
                            newJob.setEngineURL(engineUrlToFill.get(0));
                            newJob.setSubmissionAttemptNo(1);
                            runningJobsList.add(newJob);
                            logger.debug((Object)"Created a Job!");
                            ++startingPage;
                        }
                    }
                    numberOfNodesChanged = false;
                    jobsArray = new JobInfoType[runningJobsList.size()];
                    for (int j = 0; j < jobsArray.length; ++j) {
                        jobsArray[j] = (JobInfoType)runningJobsList.get(j);
                    }
                    TextExtractionJobControllerResource.this.setJobs(jobsArray);
                }
            }
        }

        public String getDTSSuggestion(HashMap<String, Long> dtsEprsMap, String[] dtsEPRs) {
            String dtsSuggestion = new String();
            try {
                dtsEPRs = ServiceUtils.getEPRsForService("DataTransformation", "DataTransformationService", SrvType.SIMPLE.name(), this.scope);
            }
            catch (GCUBEScope.MalformedScopeExpressionException e) {
                logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
            }
            if (dtsEPRs != null) {
                boolean found = false;
                String dte = null;
                Iterator<String> i$ = dtsEprsMap.keySet().iterator();
                block3: while (i$.hasNext()) {
                    String depr;
                    dte = depr = i$.next();
                    for (int d = 0; d < dtsEPRs.length; ++d) {
                        if (!dtsEPRs[d].equals(depr)) continue;
                        found = true;
                        continue block3;
                    }
                }
                if (!found && dte != null) {
                    dtsEprsMap.remove(dte);
                }
                String newDTSEpr = null;
                for (int d = 0; d < dtsEPRs.length; ++d) {
                    if (dtsEprsMap.keySet().contains(dtsEPRs[d])) continue;
                    Long time = System.currentTimeMillis();
                    dtsEprsMap.put(dtsEPRs[d], time);
                    newDTSEpr = dtsEPRs[d];
                }
                if (newDTSEpr == null) {
                    String oldestEpr = new String();
                    Iterator<String> i$2 = dtsEprsMap.keySet().iterator();
                    if (i$2.hasNext()) {
                        String key;
                        oldestEpr = key = i$2.next();
                    }
                    for (String key : dtsEprsMap.keySet()) {
                        long old = dtsEprsMap.get(oldestEpr);
                        long other = dtsEprsMap.get(key);
                        if (other >= old) continue;
                        oldestEpr = new String(key);
                    }
                    Long time = System.currentTimeMillis();
                    dtsSuggestion = oldestEpr;
                    dtsEprsMap.put(oldestEpr, time);
                } else {
                    dtsSuggestion = newDTSEpr;
                    dtsEprsMap.put(newDTSEpr, System.currentTimeMillis());
                }
            }
            logger.debug((Object)("DTSSuggestion is: " + dtsSuggestion));
            return dtsSuggestion;
        }

        public String getOCRSuggestion(HashMap<String, Long> ocrEprsMap, String[] ocrEPRs) {
            String ocrSuggestion = new String();
            try {
                ocrEPRs = ServiceUtils.getEPRsForService("Execution", "OCRService", SrvType.FACTORY.name(), this.scope);
            }
            catch (GCUBEScope.MalformedScopeExpressionException e) {
                logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"Error while retrieving EPRs for DTS", (Throwable)e);
            }
            if (ocrEPRs != null) {
                boolean found = false;
                String ocre = null;
                Iterator<String> i$ = ocrEprsMap.keySet().iterator();
                block3: while (i$.hasNext()) {
                    String oepr;
                    ocre = oepr = i$.next();
                    for (int d = 0; d < ocrEPRs.length; ++d) {
                        if (!ocrEPRs[d].equals(oepr)) continue;
                        found = true;
                        continue block3;
                    }
                }
                if (!found && ocre != null) {
                    ocrEprsMap.remove(ocre);
                }
                String newOCREpr = null;
                for (int d = 0; d < ocrEPRs.length; ++d) {
                    if (ocrEprsMap.keySet().contains(ocrEPRs[d])) continue;
                    Long time = System.currentTimeMillis();
                    ocrEprsMap.put(ocrEPRs[d], time);
                    newOCREpr = ocrEPRs[d];
                }
                if (newOCREpr == null) {
                    String oldestEpr = new String();
                    Iterator<String> i$2 = ocrEprsMap.keySet().iterator();
                    if (i$2.hasNext()) {
                        String key;
                        oldestEpr = key = i$2.next();
                    }
                    for (String key : ocrEprsMap.keySet()) {
                        long old = ocrEprsMap.get(oldestEpr);
                        long other = ocrEprsMap.get(key);
                        if (other >= old) continue;
                        oldestEpr = new String(key);
                    }
                    Long time = System.currentTimeMillis();
                    ocrSuggestion = oldestEpr;
                    ocrEprsMap.put(oldestEpr, time);
                } else {
                    ocrSuggestion = newOCREpr;
                    ocrEprsMap.put(newOCREpr, System.currentTimeMillis());
                }
            }
            logger.debug((Object)("OCRSuggestion is: " + ocrSuggestion));
            return ocrSuggestion;
        }
    }
}

