/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeoanalyticsHome
extends GenericPortlet {
    protected String backendURL;
    protected String viewTemplate;
    protected String username;
    protected String user;
    protected String pass;
    protected String tenant;
    private static Log _log = LogFactoryUtil.getLog(GeoanalyticsHome.class);
    private Gson gson = new Gson();

    public void init() {
        this.viewTemplate = this.getInitParameter("views");
        this.backendURL = this.getInitParameter("back-end-url");
        this.username = this.getInitParameter("user-name");
        Authenticator.setDefault((Authenticator)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String uri = this.backendURL + (renderRequest.getParameter("jspPage") == null || renderRequest.getParameter("jspPage").equals("./") ? "" : renderRequest.getParameter("jspPage").replace(".jsp", ""));
        if (renderRequest.getParameter("getParams") != null) {
            uri = uri + "?" + renderRequest.getParameter("getParams");
        }
        URL obj = new URL(uri);
        HttpURLConnection conn = (HttpURLConnection)obj.openConnection();
        conn.setRequestProperty("modelRequest", "true");
        String cookie = "";
        String jSessionId = (String)renderRequest.getPortletSession().getAttribute("JSESSIONID");
        if (jSessionId != null && !jSessionId.isEmpty() && !jSessionId.equals("null")) {
            cookie = "JSESSIONID=" + URLEncoder.encode(jSessionId, "UTF-8");
        }
        try {
            String screenName = null;
            if (renderRequest.getRemoteUser() != null) {
                long userid = Long.parseLong(renderRequest.getRemoteUser());
                User user = UserLocalServiceUtil.getUser((long)userid);
                screenName = user.getScreenName();
            } else {
                screenName = "guest";
            }
            cookie = cookie + (!cookie.isEmpty() ? "; " : "") + "username=" + this.username;
            conn.setRequestProperty("Cookie", cookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        conn.setInstanceFollowRedirects(false);
        conn = GeoanalyticsHome.connect((HttpURLConnection)conn);
        this.include(this.viewTemplate, renderRequest, renderResponse);
        if (conn.getResponseCode() != 200) {
            renderResponse.getWriter().write("error: " + conn.getResponseCode());
            renderResponse.getWriter().write("\nmsg: " + conn.getResponseMessage());
            try {
                renderResponse.getWriter().write(CharStreams.toString((Readable)new InputStreamReader(conn.getInputStream(), Charsets.UTF_8)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private static HttpURLConnection connect(HttpURLConnection conn) throws IOException {
        int retries = 3;
        while (retries > 0) {
            int status = conn.getResponseCode();
            retries = status != 200 ? (status != 302 && status != 301 && status != 303 ? 0 : --retries) : 0;
            if (retries <= 0) continue;
            String method = conn.getRequestMethod();
            String newUrl = conn.getHeaderField("Location");
            Map<String, List<String>> reqProps = conn.getRequestProperties();
            String cookies = conn.getHeaderField("Set-Cookie");
            conn = (HttpURLConnection)new URL(newUrl).openConnection();
            conn.setRequestMethod(method);
            for (Map.Entry<String, List<String>> prop : reqProps.entrySet()) {
                conn.setRequestProperty(prop.getKey(), prop.getValue().get(0));
            }
            conn.setRequestProperty("Cookie", cookies);
        }
        return conn;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        super.processAction(actionRequest, actionResponse);
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        boolean fetchTenantAndUsername = ParamUtil.getBoolean((PortletRequest)resourceRequest, (String)"fetchTenantAndUsername");
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        if (fetchTenantAndUsername) {
            jsonObject = this.retrieveTenantAndUsername(resourceRequest);
        }
        try {
            InputStream is = resourceRequest.getPortletInputStream();
            byte[] postData = ByteStreams.toByteArray((InputStream)is);
            is.close();
            int postDataLength = postData.length;
            String request = this.backendURL + resourceRequest.getResourceID();
            URL url = new URL(request);
            HttpURLConnection cox = (HttpURLConnection)url.openConnection();
            String cookie = "";
            String jSessionId = (String)resourceRequest.getPortletSession().getAttribute("JSESSIONID");
            if (jSessionId != null && !jSessionId.isEmpty() && !jSessionId.equals("null")) {
                cookie = "JSESSIONID=" + URLEncoder.encode(jSessionId, "UTF-8");
            }
            try {
                String userUUID = null;
                if (resourceRequest.getRemoteUser() != null) {
                    long userid = Long.parseLong(resourceRequest.getRemoteUser());
                    User user = UserLocalServiceUtil.getUser((long)userid);
                    userUUID = user.getUserUuid();
                } else {
                    userUUID = new UUID(0L, 0L).toString();
                }
                if (userUUID != null) {
                    cookie = cookie + (!cookie.isEmpty() ? "; " : "") + "username=" + this.username;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!cookie.isEmpty()) {
                cox.setRequestProperty("Cookie", cookie);
            }
            cox.setDoOutput(true);
            cox.setDoInput(true);
            cox.setInstanceFollowRedirects(false);
            cox.setRequestMethod(resourceRequest.getMethod());
            if (resourceRequest.getContentType() != null) {
                cox.setRequestProperty("Content-Type", resourceRequest.getContentType());
            }
            cox.setRequestProperty("charset", resourceRequest.getCharacterEncoding());
            cox.setUseCaches(false);
            if (postDataLength > 0) {
                cox.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                DataOutputStream wr = new DataOutputStream(cox.getOutputStream());
                wr.write(postData);
            }
            cox.connect();
            if (cox.getResponseCode() != 200) {
                throw new IOException("Response code: " + cox.getResponseCode() + " . response msg: " + cox.getResponseMessage());
            }
            if (cox.getContentType() != null) {
                resourceResponse.setContentType(cox.getContentType());
            }
            resourceResponse.setCharacterEncoding(cox.getContentEncoding());
            resourceResponse.setContentLength(cox.getContentLength());
            if (cox.getHeaderField("Content-Disposition") != null) {
                resourceResponse.setProperty("Content-Disposition", cox.getHeaderField("Content-Disposition"));
            }
            ByteStreams.copy((InputStream)cox.getInputStream(), (OutputStream)resourceResponse.getPortletOutputStream());
            String cookieSessionId = GeoanalyticsHome.getHeaderValue((String)cox.getHeaderField("Set-Cookie"), (String)"JSESSIONID");
            if (cookieSessionId != null) {
                resourceRequest.getPortletSession().setAttribute("JSESSIONID", (Object)cookieSessionId);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (fetchTenantAndUsername) {
            resourceResponse.getWriter().println(jsonObject);
        }
        super.serveResource(resourceRequest, resourceResponse);
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        super.doDispatch(request, response);
    }

    protected void include(String path, RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        String url = null;
        url = renderRequest.getParameter("jspPage") == null || renderRequest.getParameter("jspPage").equals("./") ? path + "view.jsp" : path + renderRequest.getParameter("jspPage");
        PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher(url);
        if (portletRequestDispatcher == null) {
            _log.error((Object)(url + " is not a valid include"));
        } else {
            ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this.username = themeDisplay.getUser().getFullName();
            portletRequestDispatcher.include(renderRequest, renderResponse);
        }
    }

    private static String getHeaderValue(String field, String name) {
        if (field != null) {
            for (String value : field.split("; ")) {
                if (!value.startsWith(name + "=")) continue;
                return value.replace(name + "=", "");
            }
        }
        return null;
    }

    private JSONObject retrieveTenantAndUsername(ResourceRequest resourceRequest) {
        JSONObject jo = JSONFactoryUtil.createJSONObject();
        try {
            this.tenant = "devsec/vre";
            jo.put("tenant", this.tenant);
            jo.put("fullname", this.username);
            jo.put("email", "something@some.com");
            jo.put("initials", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jo;
    }
}

