/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.repository;

import it.eng.d4s.sa3.repository.RepositoryException;
import it.eng.d4s.sa3.repository.SA3Repository;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.log4j.Logger;

public abstract class SubRepository {
    private static final Logger LOGGER = Logger.getLogger(SubRepository.class);
    protected SA3Repository sa3Repo;
    protected String homeDir;

    public SubRepository(SA3Repository sa3Repo, String homeDir) {
        this.sa3Repo = sa3Repo;
        this.homeDir = homeDir;
    }

    public SA3Repository getSA3Repo() {
        return this.sa3Repo;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getAbsoluteResourcePath(String resourcePath) {
        return String.valueOf(this.homeDir) + File.separator + resourcePath;
    }

    public boolean resourceExists(String resourcePath) {
        String absPath = String.valueOf(this.homeDir) + "/" + resourcePath;
        File res = new File(absPath);
        return res.exists();
    }

    public InputStream getResourceIS(String resourcePath) throws RepositoryException {
        String absPath = this.getAbsoluteResourcePath(resourcePath);
        try {
            FileInputStream is = new FileInputStream(absPath);
            LOGGER.debug((Object)("Resource " + absPath + " loaded."));
            return is;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error loading resource " + absPath + ". Error was: " + e.getMessage()));
            throw new RepositoryException(e);
        }
    }

    public String toString() {
        return "[REPO:" + this.homeDir + "]";
    }
}

