/*
 * Decompiled with CFR 0.152.
 */
package org.diligentproject.support;

import java.io.File;
import org.diligentproject.support.Util;

public class TypeStatistics {
    private String name;
    private Long files;
    private Long size;

    public TypeStatistics(String type) {
        this.name = type;
        this.files = 0L;
        this.size = 0L;
    }

    public void include(TypeStatistics ts) {
        if (!this.getName().equals(ts.getName())) {
            return;
        }
        this.files = this.files + ts.getFiles();
        this.size = this.size + ts.getSize();
    }

    public void include(File f) {
        this.files = this.files + 1L;
        this.size = this.size + f.length();
    }

    public Long getSize() {
        return this.size;
    }

    public Long getFiles() {
        return this.files;
    }

    public String toXML() {
        return "<type name='" + this.name + "' files='" + this.files + "' bytes='" + this.size + "' size='" + Util.getShortSize(this.size) + "' unit='" + Util.getSizeUnit(this.size) + "'/>";
    }

    public String toHTML() {
        if (this.files == 0L) {
            return "<td></td>";
        }
        return "<td><b>" + this.name + "</b><br>" + this.files + " files<br><small>(" + Util.getShortSize(this.size) + ")</small></td>";
    }

    public String toRawHTML() {
        if (this.files == 0L) {
            return "<td></td>";
        }
        return "<td><b>" + this.name + "</b></td><td>" + this.files + " files</td><td><small>(" + Util.getShortSize(this.size) + ")</small></td>";
    }

    public String getName() {
        return this.name;
    }
}

