/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.report.configurations;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.etics.buildsystem.stub.BuildSystemService;
import org.etics.buildsystem.stub.BuildSystemServiceServiceLocator;
import org.etics.buildsystem.stub.Configuration;
import org.gcube.tools.report.configurations.ConfigurationsReport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationsReportGenerator {
    public static final String ETICS_WS_ENDPOINT_URL = "http://etics.eng.it/BuildSystemService/services/BuildSystemService";
    private BuildSystemService eticsService;

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ConfigurationsReportGenerator.class + " <init|add> [OPTIONS]", options);
    }

    public BuildSystemService getETICSWs() throws ServiceException {
        if (this.eticsService == null) {
            BuildSystemServiceServiceLocator locator = new BuildSystemServiceServiceLocator();
            locator.setEndpointAddress("BuildSystemService", ETICS_WS_ENDPOINT_URL);
            this.eticsService = locator.getBuildSystemService();
        }
        return this.eticsService;
    }

    public List<String> getBuiltConfigs(File buildStatus) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Document buildStatusDoc = dBuilder.parse(buildStatus);
        LinkedList<String> output = new LinkedList<String>();
        NodeList modules = (NodeList)xPath.evaluate("/project/modules/module", buildStatusDoc, XPathConstants.NODESET);
        int i = 0;
        while (i < modules.getLength()) {
            Node module = modules.item(i);
            String is = (String)xPath.evaluate("@configid", module, XPathConstants.STRING);
            output.add(is);
            ++i;
        }
        return output;
    }

    public static void main(String[] args) throws ParseException, XPathExpressionException, ParserConfigurationException, SAXException, IOException, TransformerException {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"print this message");
        Option helpOpt = OptionBuilder.create((String)"h");
        OptionBuilder.withLongOpt((String)"buildstatus");
        OptionBuilder.withArgName((String)"build-status.xml");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"path to build-status.xml file");
        Option buildStatusOpt = OptionBuilder.create((String)"b");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"output txt file. If not provided prints on stdout");
        Option outputFileOpt = OptionBuilder.create((String)"o");
        Options options = new Options();
        options.addOption(helpOpt);
        options.addOption(buildStatusOpt);
        options.addOption(outputFileOpt);
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption(helpOpt.getOpt())) {
            ConfigurationsReportGenerator.printHelp(options);
            return;
        }
        File outputFile = null;
        if (cmd.hasOption("o")) {
            outputFile = new File(cmd.getOptionValue("o"));
        } else {
            System.err.println("output file not specified. Cannot continue. Exiting...");
            System.exit(1);
        }
        File buildStatus = null;
        buildStatus = cmd.hasOption("b") ? new File(cmd.getOptionValue("b")) : new File("build-status.xml");
        if (!buildStatus.exists()) {
            System.err.println("build-status.xml file " + buildStatus + " does not exist. Cannot continue. Exiting...");
            System.exit(1);
        }
        ConfigurationsReportGenerator instance = new ConfigurationsReportGenerator();
        List<String> builtConfigs = instance.getBuiltConfigs(buildStatus);
        ConfigurationsReport rc = ConfigurationsReport.init(outputFile);
        for (String confId : builtConfigs) {
            try {
                Configuration c = instance.getETICSWs().getConfigurationById(confId);
                System.out.println("Adding " + c.getName());
                rc.addEntry(c.getName(), c.getStatus());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        rc.save();
    }
}

