/*
 * Decompiled with CFR 0.152.
 */
package org.diligentproject.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.diligentproject.support.ModuleProcessor;
import org.diligentproject.support.TypeStatistics;
import org.diligentproject.support.Util;

public class Workspace {
    private String name;
    private Map<String, TypeStatistics> types;
    private SortedSet<ModuleProcessor> modules = new TreeSet<ModuleProcessor>();

    public Workspace(String path) {
        this.types = new HashMap<String, TypeStatistics>();
        File workspace = new File(path);
        this.name = workspace.getName();
        File[] fileArray = workspace.listFiles();
        int n = 0;
        int n2 = fileArray.length;
        while (n < n2) {
            File module = fileArray[n];
            try {
                String name = module.getName();
                if (!(name.equals("etics") || name.equals("dist") || name.equals("reports") || name.equals("repository") || name.equals("stage"))) {
                    ModuleProcessor p = new ModuleProcessor(module);
                    System.out.println(module.getName());
                    this.modules.add(new ModuleProcessor(module));
                    this.includeAll(p);
                }
            }
            catch (Exception e) {
                System.out.println(String.valueOf(module.getName()) + "...SKIPPED");
            }
            ++n;
        }
        System.out.println("DONE!");
    }

    private void includeAll(ModuleProcessor mp) {
        for (TypeStatistics ts : mp.getTypeStatistics()) {
            this.include(ts);
        }
    }

    private void include(TypeStatistics ts) {
        TypeStatistics localTs = this.types.get(ts.getName());
        if (localTs == null) {
            localTs = new TypeStatistics(ts.getName());
            this.types.put(localTs.getName(), ts);
        }
        localTs.include(ts);
    }

    public String toXML() {
        String out = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
        Long size = this.getSize();
        Long files = this.getFiles();
        out = String.valueOf(out) + "<workspace name='" + this.getName() + "' bytes='" + size + "' files='" + files + "' size='" + Util.getShortSize(size) + "' unit='" + Util.getSizeUnit(size) + "'>\n";
        for (ModuleProcessor mp : this.modules) {
            out = String.valueOf(out) + mp.toXML();
        }
        for (String k : this.types.keySet()) {
            out = String.valueOf(out) + this.types.get(k).toXML() + "\n";
        }
        out = String.valueOf(out) + "</workspace>";
        return out;
    }

    public Long getSize() {
        Long size = 0L;
        for (ModuleProcessor mp : this.modules) {
            size = size + mp.getSize();
        }
        return size;
    }

    public Long getFiles() {
        Long files = 0L;
        for (ModuleProcessor mp : this.modules) {
            files = files + mp.getFiles();
        }
        return files;
    }

    public static void main(String[] args) {
        System.out.println("Creating statistics for " + args[0]);
        Workspace ws = new Workspace(args[0]);
        try {
            FileOutputStream os = new FileOutputStream(args[1]);
            ((OutputStream)os).write(ws.toXML().getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return this.name;
    }
}

