/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools;

import it.eng.d4s.sa3.util.Version;
import java.io.File;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.gcube.tools.report.distribution.DistributionLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DistributionReportGenerator {
    public static final String WIKIDOC_MATCHING_PATTERN = "(https://gcube.wiki.gcube-system.org/gcube/index.php.*)|(https://technical.wiki.d4science.research-infrastructures.eu/documentation.*)";
    private static boolean acceptSnapshots = false;

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(DistributionReportGenerator.class + " <init|add> [OPTIONS]", options);
    }

    private static void initializeDistributionReport(File dReport, File logReport) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("Packages");
        doc.appendChild(rootElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "8");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult("file://" + dReport.getAbsolutePath());
        transformer.transform(source, result);
        DistributionLog dl = DistributionLog.init(logReport);
        dl.save();
    }

    private static void validatePackage(Node packageNode, Node profile, DistributionLog dl, File SADir, String ETICSRef, String packageName) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        String groupId = (String)xPath.evaluate("groupID", packageNode, XPathConstants.STRING);
        String artifactId = (String)xPath.evaluate("artifactID", packageNode, XPathConstants.STRING);
        String version = (String)xPath.evaluate("version", packageNode, XPathConstants.STRING);
        String javadoc = (String)xPath.evaluate("javadoc", packageNode, XPathConstants.STRING);
        String URL2 = (String)xPath.evaluate("URL", packageNode, XPathConstants.STRING);
        if (URL2.equals("null")) {
            dl.addError("URL null for artifact " + groupId + ":" + artifactId, ETICSRef);
        }
        if (javadoc.equals("null")) {
            dl.addWarning("javadoc URL null for artifact " + groupId + ":" + artifactId, ETICSRef);
        }
        if (groupId.equals("null")) {
            dl.addError("groupId null for artifact " + groupId + ":" + artifactId, ETICSRef);
        }
        if (artifactId.equals("null")) {
            dl.addError("artifactId null for artifact " + groupId + ":" + artifactId, ETICSRef);
        }
        if (version.equals("null")) {
            dl.addError("version is null for artifact " + groupId + ":" + artifactId, ETICSRef);
        }
        if (version.endsWith("-SNAPSHOT")) {
            if (!acceptSnapshots) {
                dl.addError("SNAPSHOT version found for artifact " + groupId + ":" + artifactId, ETICSRef);
            }
        } else if (acceptSnapshots) {
            dl.addError("RELEASE version found for artifact " + groupId + ":" + artifactId, ETICSRef);
        }
        if (profile != null) {
            if (packageName == null || packageName.equals("")) {
                dl.addError("Impossible to find any package with artifactId \"" + artifactId + "\" in profile.xml", ETICSRef);
            } else {
                File packageFolder = new File(SADir + File.separator + packageName);
                if (!packageFolder.exists()) {
                    dl.addError("folder for package " + packageName + " does not exist", ETICSRef);
                }
                NodeList files = (NodeList)xPath.evaluate("//Files[../MavenCoordinates/artifactId/text()=\"" + artifactId + "\"]/File | //GARArchive[../MavenCoordinates/artifactId/text()=\"" + artifactId + "\"]", profile, XPathConstants.NODESET);
                int j = 0;
                while (j < files.getLength()) {
                    String f = files.item(j).getTextContent();
                    File t = new File(SADir + File.separator + packageName + File.separator + f);
                    if (!t.exists()) {
                        dl.addError("file " + f + " does not exist in package " + packageName, ETICSRef);
                    }
                    ++j;
                }
            }
        }
    }

    private static void processSA(File distributionReport, DistributionLog dl, File SGReport, File artifactDir, String ETICSRef) throws Exception {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        if (!artifactDir.isDirectory()) {
            System.err.println("Ther artifact directory " + artifactDir + " does not exist. Cannot continue");
            dl.addError("servicearchive package not valid or not existent", ETICSRef);
            return;
        }
        String wikidocURL = null;
        File readmeFile = new File(artifactDir + File.separator + "README");
        if (!readmeFile.exists()) {
            dl.addWarning("README file not found", ETICSRef);
        } else {
            String readmeText = new Scanner(readmeFile).useDelimiter("\\Z").next();
            Pattern p = Pattern.compile(WIKIDOC_MATCHING_PATTERN);
            Matcher m = p.matcher(new String(readmeText));
            if (m.find()) {
                wikidocURL = m.group();
            } else {
                dl.addWarning("wikidoc URL not found in README", ETICSRef);
            }
        }
        String globalSVN = null;
        File globalSvnpath = new File(artifactDir + File.separator + "svnpath.txt");
        if (globalSvnpath.exists()) {
            globalSVN = new Scanner(globalSvnpath).useDelimiter("\\Z").next();
        }
        File profileFile = new File(artifactDir + File.separator + "profile.xml");
        Document docProfile = null;
        if (!profileFile.exists()) {
            dl.addError("profile.xml not found", ETICSRef);
        } else {
            docProfile = dBuilder.parse(profileFile);
            String serviceVersion = (String)xPath.evaluate("//Profile/Version/text()", docProfile, XPathConstants.STRING);
            Version v = new Version(serviceVersion);
            String normalizedVersion = v.getNormalizedRepresentation();
            if (!normalizedVersion.equals("1.0.0-0")) {
                dl.addError("serviceVersion not equals to 1.0.0 (was " + serviceVersion + ")", ETICSRef);
            }
        }
        if (!SGReport.exists()) {
            dl.addError("SG Report not found", ETICSRef);
            return;
        }
        Document SGReportDoc = dBuilder.parse(SGReport);
        Document distributionReportDoc = dBuilder.parse(distributionReport);
        Node dreportPackages = (Node)xPath.evaluate("/Packages", distributionReportDoc, XPathConstants.NODE);
        NodeList SGpackageNodes = (NodeList)xPath.evaluate("/Packages/Package", SGReportDoc, XPathConstants.NODESET);
        int i = 0;
        while (i < SGpackageNodes.getLength()) {
            Node packageNode = SGpackageNodes.item(i);
            String artifactId = (String)xPath.evaluate("artifactID", packageNode, XPathConstants.STRING);
            String sgStatus = (String)xPath.evaluate("Status", packageNode, XPathConstants.STRING);
            if (sgStatus.equals("ERROR")) {
                dl.addError("SG Report Status is ERROR for artifactId " + artifactId, ETICSRef);
            } else if (sgStatus.equals("WARN")) {
                dl.addWarning("SG Report Status is WARN for artifactId " + artifactId, ETICSRef);
            } else if (sgStatus.equals("SUCCESS")) {
                dl.addInfo("SG Report Status is SUCCESS for artifactId " + artifactId, ETICSRef);
            } else {
                dl.addError("SG Report Status is unknown for artifactId " + artifactId, ETICSRef);
            }
            String packageName = (String)xPath.evaluate("//Name[../MavenCoordinates/artifactId/text()=\"" + artifactId + "\"]/text()", docProfile, XPathConstants.STRING);
            DistributionReportGenerator.validatePackage(packageNode, docProfile, dl, artifactDir, ETICSRef, packageName);
            String svnpath = globalSVN;
            if (svnpath == null) {
                try {
                    svnpath = new Scanner(new File(artifactDir + File.separator + packageName + File.separator + "svnpath.txt")).useDelimiter("\\Z").next();
                }
                catch (Exception e) {
                    dl.addWarning("svnpath.txt not found for packate " + packageName, ETICSRef);
                }
            }
            Element el = packageNode.getOwnerDocument().createElement("wikidoc");
            el.setTextContent(wikidocURL);
            packageNode.appendChild(el);
            Element el2 = packageNode.getOwnerDocument().createElement("svnpath");
            el2.setTextContent(svnpath);
            packageNode.appendChild(el2);
            Element el3 = packageNode.getOwnerDocument().createElement("ETICSRef");
            el3.setTextContent(ETICSRef);
            packageNode.appendChild(el3);
            Node packageImported = distributionReportDoc.importNode(packageNode, true);
            dreportPackages.appendChild(packageImported);
            ++i;
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "8");
        DOMSource source = new DOMSource(distributionReportDoc);
        StreamResult result = new StreamResult(distributionReport);
        transformer.transform(source, result);
    }

    public static void main(String[] args) throws Exception {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"print this message");
        Option helpOpt = OptionBuilder.create((String)"h");
        OptionBuilder.withLongOpt((String)"dreport");
        OptionBuilder.withArgName((String)"DISTRIBUTION.XML");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the distribution.xml file to use as output. By default it is distribution.xml");
        Option dreportOpt = OptionBuilder.create((String)"d");
        OptionBuilder.withLongOpt((String)"packages");
        OptionBuilder.withArgName((String)"PACKAGES.XML");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"packages report. It is returned by the software gatewasy client. By default it is report.xml");
        Option packagesOpt = OptionBuilder.create((String)"p");
        OptionBuilder.withLongOpt((String)"artifactname");
        OptionBuilder.withArgName((String)"FOLDER");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the artifact name");
        Option artifactNameOpt = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"artifactdir");
        OptionBuilder.withArgName((String)"FOLDER");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the artifact directory");
        Option artifactDirOpt = OptionBuilder.create((String)"r");
        OptionBuilder.withLongOpt((String)"logreport");
        OptionBuilder.withArgName((String)"DISTRIBUTION_LOG.XML");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the default is distribution_log.xml");
        Option logReportOpt = OptionBuilder.create((String)"l");
        OptionBuilder.withLongOpt((String)"snapshots");
        OptionBuilder.withDescription((String)"whether postifx verion with -SNAPSHOT or not.");
        Option acceptSnapshotsOpt = OptionBuilder.create((String)"s");
        Options options = new Options();
        options.addOption(helpOpt);
        options.addOption(dreportOpt);
        options.addOption(packagesOpt);
        options.addOption(artifactNameOpt);
        options.addOption(artifactDirOpt);
        options.addOption(logReportOpt);
        options.addOption(acceptSnapshotsOpt);
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption(helpOpt.getOpt())) {
            DistributionReportGenerator.printHelp(options);
            return;
        }
        if (cmd.hasOption("s")) {
            acceptSnapshots = true;
        }
        File dReport = null;
        dReport = cmd.hasOption("d") ? new File(cmd.getOptionValue("d")) : new File("distribution.xml");
        File logReport = null;
        logReport = cmd.hasOption("l") ? new File(cmd.getOptionValue("l")) : new File("distribution_log.xml");
        File packagesReport = null;
        packagesReport = cmd.hasOption("p") ? new File(cmd.getOptionValue("p")) : new File("report.xml");
        File artifactDir = null;
        artifactDir = cmd.hasOption("r") ? new File(cmd.getOptionValue("r")) : new File("artifacttmp");
        String artifactName = cmd.getOptionValue("a");
        String command = args[0];
        if (command.equals("init")) {
            DistributionReportGenerator.initializeDistributionReport(dReport, logReport);
        } else if (command.equals("add")) {
            DistributionLog distributionLog = DistributionLog.load(logReport);
            try {
                DistributionReportGenerator.processSA(dReport, distributionLog, packagesReport, artifactDir, artifactName);
            }
            catch (Exception e) {
                e.printStackTrace();
                distributionLog.addError("Error processing servicearchive", artifactName);
            }
            distributionLog.save();
        } else {
            System.err.println("command (first parameter) must be one of 'init' or 'add'. It was: " + command);
        }
    }
}

