/*
 * Decompiled with CFR 0.152.
 */
package org.diligentproject.support;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.diligentproject.support.TypeStatistics;
import org.diligentproject.support.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleProcessor
implements Comparable<ModuleProcessor> {
    private String name;
    private Map<String, TypeStatistics> types;

    public ModuleProcessor(File f) throws Exception {
        if (!f.isDirectory()) {
            throw new Exception(String.valueOf(f.getName()) + " is not a directory");
        }
        if (f.getName().startsWith(".")) {
            throw new Exception(String.valueOf(f.getName()) + " is an hidden directory");
        }
        this.name = f.getName();
        this.types = new TreeMap<String, TypeStatistics>();
        this.analyseFile(f);
    }

    public ModuleProcessor(String pathToModuleRoot) throws Exception {
        this(new File(pathToModuleRoot));
    }

    public Collection<TypeStatistics> getTypeStatistics() {
        return this.types.values();
    }

    public Long getFiles() {
        long files = 0L;
        for (TypeStatistics ts : this.types.values()) {
            files += ts.getFiles().longValue();
        }
        return files;
    }

    public Long getSize() {
        long size = 0L;
        for (TypeStatistics ts : this.types.values()) {
            size += ts.getSize().longValue();
        }
        return size;
    }

    private void analyseFile(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File f = fileArray[n];
                this.analyseFile(f);
                ++n;
            }
        } else if (file.isFile()) {
            String extension = Util.getExtension(file.getName());
            this.include(extension, file);
        }
    }

    private void include(String type, File f) {
        TypeStatistics ts = this.types.get(type);
        if (ts == null) {
            ts = new TypeStatistics(type);
            this.types.put(type, ts);
        }
        ts.include(f);
    }

    public String toXML() {
        long files = this.getFiles();
        long size = this.getSize();
        String out = "<module name='" + this.getName() + "' bytes='" + size + "' size='" + Util.getShortSize(size) + "' unit='" + Util.getSizeUnit(size) + "' files='" + files + "'>\n";
        for (String k : this.types.keySet()) {
            out = String.valueOf(out) + this.types.get(k).toXML() + "\n";
        }
        out = String.valueOf(out) + "</module>\n";
        return out;
    }

    public String toHTML(String[] types) {
        long files = this.getFiles();
        long size = this.getSize();
        String html = "<tr>\n";
        html = String.valueOf(html) + "<td><b>" + this.getName() + "</b><br>" + files + " files<br><small>(" + Util.getShortSize(size) + ")</small></td>\n";
        String[] stringArray = types;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            TypeStatistics ts = this.types.get(t);
            html = ts == null ? String.valueOf(html) + "<td></td><td></td><td></td>\n" : String.valueOf(html) + ts.toHTML() + "\n";
            ++n;
        }
        html = String.valueOf(html) + "</tr>\n";
        return html;
    }

    public Long getSize(String type) {
        try {
            return this.types.get(type).getSize();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public Long getFiles(String type) {
        try {
            return this.types.get(type).getFiles();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public Collection<String> getTypes() {
        return this.types.keySet();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(ModuleProcessor p) {
        return this.getName().toLowerCase().compareTo(p.getName().toLowerCase());
    }
}

