/*
 * Decompiled with CFR 0.152.
 */
package org.diligentproject.support;

public class Util {
    public static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            return fileName.substring(index + 1);
        }
        return "unknown";
    }

    public static String getShortSize(Long size) {
        if (size < 1024L) {
            return size.toString();
        }
        if (size < 0x100000L) {
            return String.valueOf(size / 1024L);
        }
        if (size < 0x40000000L) {
            return String.valueOf(size / 1024L / 1024L);
        }
        return String.valueOf((float)((int)((float)size.longValue() / 1024.0f / 1024.0f / 1024.0f * 100.0f)) / 100.0f);
    }

    public static String getSizeUnit(Long size) {
        if (size < 1024L) {
            return "Bytes";
        }
        if (size < 0x100000L) {
            return "KB";
        }
        if (size < 0x40000000L) {
            return "MB";
        }
        return "GB";
    }
}

