package org.gcube.tools;

import java.io.File;
import java.text.DateFormat;
import java.util.Collections;
import java.util.GregorianCalendar;

import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.LoginLevel;

import it.geosolutions.geonetwork.util.GNSearchRequest;

public class SingleDownload {

	public static void main(String[] args) throws Exception {
		TokenSetter.set("/d4science.research-infrastructures.eu");
		GeoNetworkReader reader=GeoNetwork.get();
		GNSearchRequest req=new GNSearchRequest();
		reader.login(LoginLevel.ADMIN);
		req.addParam(GNSearchRequest.Param.any, "lgastropteronpacificum20130414135444947cest");
		req.addConfig(GNSearchRequest.Config.similarity, "1");
		File temp=new File(System.getProperty("java.io.tmpdir"),"XML");
		temp.mkdirs();
		long id=reader.query(req).getMetadata(0).getId();
		System.out.println(Utils.meta2File(temp, DateFormat.getInstance().format(new GregorianCalendar().getTime()).replace("/", "_"), reader.getById(id), Collections.EMPTY_LIST));

	}

}
