/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.mycontainer;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.mycontainer.Deployment;
import org.gcube.common.mycontainer.Gar;
import org.gcube.common.mycontainer.MyContainer;
import org.gcube.common.mycontainer.Reference;
import org.gcube.common.mycontainer.Scope;
import org.gcube.common.scope.api.ScopeProvider;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class MyContainerTestRunner
extends BlockJUnit4ClassRunner {
    MyContainer container;
    Field containerField;
    List<Gar> gars = new ArrayList<Gar>();

    public MyContainerTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        if (this.getTestClass().getJavaClass().isAnnotationPresent(Scope.class)) {
            ScopeProvider.instance.set(this.getTestClass().getJavaClass().getAnnotation(Scope.class).value());
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FrameworkField ffield : this.getTestClass().getAnnotatedFields(Inject.class)) {
            Field field = ffield.getField();
            if (!field.getType().isAssignableFrom(MyContainer.class)) continue;
            fields.add(field);
        }
        if (!fields.isEmpty()) {
            if (fields.size() > 1) {
                throw new InitializationError("@Inject placed on too many fields");
            }
            this.containerField = (Field)fields.get(0);
            if (this.containerField.getModifiers() != 8) {
                throw new InitializationError("@Inject can only be placed on static fields");
            }
            this.containerField.setAccessible(true);
        }
        fields = new ArrayList();
        for (FrameworkField field : this.getTestClass().getAnnotatedFields(Deployment.class)) {
            if (!field.getField().getType().isAssignableFrom(Gar.class)) {
                throw new InitializationError("field " + field.getField().getName() + " is annotated with @Gar but its type is invalid");
            }
            if (!Modifier.isStatic(field.getField().getModifiers())) {
                throw new InitializationError("field " + field.getField() + " is annotated with @Gar but it is not static");
            }
            try {
                field.getField().setAccessible(true);
                this.gars.add((Gar)Gar.class.cast(field.getField().get(null)));
            }
            catch (Throwable t) {
                throw new InitializationError(t);
            }
        }
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        String currentScope = ScopeProvider.instance.get();
        if (method.getMethod().isAnnotationPresent(Scope.class)) {
            ScopeProvider.instance.set(((Scope)method.getAnnotation(Scope.class)).value());
        }
        System.err.println("\n--- start of [" + method.getName() + "] in scope " + ScopeProvider.instance.get() + "\n");
        super.runChild(method, notifier);
        System.err.println("\n--- end of [" + method.getName() + "]\n");
        ScopeProvider.instance.set(currentScope);
    }

    protected Statement withBeforeClasses(Statement statement) {
        final Statement defaultStatement = super.withBeforeClasses(statement);
        Statement newstatement = new Statement(){

            public void evaluate() throws Throwable {
                try {
                    Class<Object> type;
                    MyContainerTestRunner.this.container = new MyContainer(MyContainerTestRunner.this.gars.toArray(new Gar[0]));
                    MyContainerTestRunner.this.container.start();
                    if (MyContainerTestRunner.this.containerField != null) {
                        MyContainerTestRunner.this.containerField.set(null, MyContainerTestRunner.this.container);
                    }
                    for (FrameworkField field : MyContainerTestRunner.this.getTestClass().getAnnotatedFields(Named.class)) {
                        if (!Modifier.isStatic(field.getField().getModifiers())) {
                            throw new InitializationError("field" + field.getField().getName() + " is annotated with @Named but it is not static");
                        }
                        type = field.getField().getType();
                        field.getField().setAccessible(true);
                        String name = field.getField().getAnnotation(Named.class).value();
                        if (type.isAssignableFrom(EndpointReferenceType.class)) {
                            field.getField().set(null, MyContainerTestRunner.this.container.reference(name));
                            continue;
                        }
                        if (type.isAssignableFrom(URI.class)) {
                            field.getField().set(null, MyContainerTestRunner.this.container.address(name));
                            continue;
                        }
                        field.getField().set(null, MyContainerTestRunner.this.container.endpoint(name, type));
                    }
                    for (FrameworkField field : MyContainerTestRunner.this.getTestClass().getAnnotatedFields(Reference.class)) {
                        if (!Modifier.isStatic(field.getField().getModifiers())) {
                            throw new InitializationError("field" + field.getField().getName() + " is annotated with @Named but it is not static");
                        }
                        type = field.getField().getType();
                        if (!type.isAssignableFrom(EndpointReferenceType.class)) {
                            throw new InitializationError("field" + field.getField().getName() + " is annotated with @Reference but it is not typed with EndpointReferenceType");
                        }
                        field.getField().setAccessible(true);
                        Reference reference = field.getField().getAnnotation(Reference.class);
                        field.getField().set(null, MyContainerTestRunner.this.container.reference(reference.name(), reference.ns(), reference.key()));
                    }
                }
                catch (Throwable t) {
                    Throwable cause = t.getCause();
                    if (cause != null) {
                        Throwable innerCause = cause.getCause();
                        if (innerCause != null) {
                            innerCause.printStackTrace();
                        } else {
                            cause.printStackTrace();
                        }
                    } else {
                        t.printStackTrace();
                    }
                    throw t;
                }
                defaultStatement.evaluate();
            }
        };
        return newstatement;
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement defaultStatement = super.withAfterClasses(statement);
        Statement newstatement = new Statement(){

            public void evaluate() throws Throwable {
                Throwable error = null;
                try {
                    defaultStatement.evaluate();
                }
                catch (Throwable t) {
                    error = t;
                }
                if (MyContainerTestRunner.this.container != null) {
                    MyContainerTestRunner.this.container.stop();
                }
                if (error != null) {
                    throw error;
                }
            }
        };
        return newstatement;
    }
}

