/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.mycontainer;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.oasis.wsrf.properties.QueryExpressionType;
import org.oasis.wsrf.properties.QueryResourcePropertiesResponse;
import org.oasis.wsrf.properties.QueryResourceProperties_Element;
import org.oasis.wsrf.properties.QueryResourceProperties_PortType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourcePropertyHelper {
    private static XPathFactory factory = XPathFactory.newInstance();
    private XPath engine = factory.newXPath();
    private Map<String, String> namespaces = new HashMap<String, String>();
    private NamespaceContext nsContext = new NamespaceContext(){

        @Override
        public String getNamespaceURI(String prefix) {
            return (String)ResourcePropertyHelper.this.namespaces.get(prefix);
        }

        public Iterator<?> getPrefixes(String val) {
            return null;
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }
    };
    private static Transformer transformer;
    private final Node document;

    public ResourcePropertyHelper(EndpointReferenceType reference) {
        try {
            this.document = ResourcePropertyHelper.propertiesOf(reference).get_any()[0].getAsDOM();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.engine.setNamespaceContext(this.nsContext);
    }

    public void addNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public String show() {
        return this.evaluate("/").get(0);
    }

    public List<String> evaluate(String xpath) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            NodeList set = this.evaluateForNodes(xpath);
            for (int i = 0; i < set.getLength(); ++i) {
                StreamResult sr = new StreamResult(new StringWriter());
                transformer.transform(new DOMSource(set.item(i)), sr);
                results.add(sr.getWriter().toString());
            }
            return results;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public NodeList evaluateForNodes(String xpath) {
        try {
            return (NodeList)this.engine.evaluate(xpath, this.document, XPathConstants.NODESET);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static QueryResourcePropertiesResponse propertiesOf(EndpointReferenceType reference) {
        try {
            String dialect = "http://www.w3.org/TR/1999/REC-xpath-19991116";
            String expression = "/";
            WSResourcePropertiesServiceAddressingLocator locator = new WSResourcePropertiesServiceAddressingLocator();
            QueryExpressionType query = new QueryExpressionType();
            query.setDialect(dialect);
            query.setValue((Object)expression);
            QueryResourceProperties_PortType port = locator.getQueryResourcePropertiesPort(reference);
            QueryResourceProperties_Element request = new QueryResourceProperties_Element();
            request.setQueryExpression(query);
            QueryResourcePropertiesResponse response = port.queryResourceProperties(request);
            if (response == null || response.get_any() == null || response.get_any().length == 0) {
                throw new Exception("could not access ws resource");
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

