/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.report.packages.util;

import it.eng.d4s.sa3.model.Build;
import it.eng.d4s.sa3.model.ModuleBuild;
import it.eng.d4s.sa3.report.ReportException;
import it.eng.d4s.sa3.report.packages.PackagesModuleReport;
import it.eng.d4s.sa3.repository.resourcetype.BuildResourceType;
import it.eng.d4s.sa3.util.GZipReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagesReportGenerator {
    private static final Logger LOGGER = Logger.getLogger(PackagesReportGenerator.class);
    public static final String WIKIDOC_MATCHING_PATTERN = "(https://gcube.wiki.gcube-system.org/gcube/index.php.*)|(https://technical.wiki.d4science.research-infrastructures.eu/documentation.*)";

    public static void generateReport(Build b, File packageModuleMappingFile) throws ReportException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement("packages");
            document.appendChild(rootElement);
            Set<PackagesModuleReport> packages = PackagesReportGenerator.generatePackagesModuleReports(b, packageModuleMappingFile);
            for (PackagesModuleReport pmr : packages) {
                Element em = document.createElement("package");
                rootElement.appendChild(em);
                Element serviceNameNode = document.createElement("service-name");
                serviceNameNode.appendChild(document.createTextNode(pmr.getServiceName()));
                em.appendChild(serviceNameNode);
                Element packageNameNode = document.createElement("package-name");
                packageNameNode.appendChild(document.createTextNode(pmr.getPackageName()));
                em.appendChild(packageNameNode);
                Element packageVersionNode = document.createElement("package-version");
                packageVersionNode.appendChild(document.createTextNode(pmr.getVersion().getRawRepresentation()));
                em.appendChild(packageVersionNode);
                Element artefactNode = document.createElement("artefact");
                artefactNode.appendChild(document.createTextNode(pmr.getArtefact()));
                em.appendChild(artefactNode);
                if (pmr.getWikidocURL() != null) {
                    Element wikidocNode = document.createElement("wikidoc");
                    wikidocNode.appendChild(document.createTextNode(pmr.getWikidocURL().toString()));
                    em.appendChild(wikidocNode);
                }
                Element moduleNode = document.createElement("etics-module");
                moduleNode.appendChild(document.createTextNode(pmr.getEticsModuleName()));
                em.appendChild(moduleNode);
            }
            File outputFile = new File(b.getRepo().getBResourceAbsolutePath(BuildResourceType.B_PACKAGES_REPORT));
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
            LOGGER.info((Object)("writing down packagesReport to " + outputFile.getAbsolutePath()));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            FileOutputStream out = new FileOutputStream(outputFile);
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new ReportException(e);
        }
    }

    private static Set<PackagesModuleReport> generatePackagesModuleReports(Build b, File packageModuleMappingFile) throws FileNotFoundException, IOException {
        Map<String, String> modulePackageMapping = PackagesReportGenerator.loadModuleMappings(packageModuleMappingFile);
        HashSet<ModuleBuild> saSet = new HashSet<ModuleBuild>();
        Collection<ModuleBuild> mbs = b.getAllModuleBuilds();
        for (ModuleBuild mb : mbs) {
            if (!mb.getModuleName().matches("^.*servicearchive.*$") || !mb.isBuilt()) continue;
            saSet.add(mb);
        }
        HashSet<PackagesModuleReport> packages = new HashSet<PackagesModuleReport>();
        for (ModuleBuild mb : saSet) {
            String tgzPath = b.getRepo().getMResourceAbsolutePath(BuildResourceType.M_TGZ_ARTEFACT, mb);
            String wikidoc = null;
            try {
                byte[] readmeText = GZipReader.getInnerEntry(tgzPath, "README");
                wikidoc = PackagesReportGenerator.extractWikidocLink(readmeText);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("README not found in servicearchive " + mb.getArtefactFilename()));
            }
            try {
                byte[] profileText = GZipReader.getInnerEntry(tgzPath, "profile.xml");
                PackagesReportGenerator.acceptProfile(profileText, mb.getArtefactFilename(), wikidoc, modulePackageMapping, packages);
            }
            catch (Exception e) {
                LOGGER.warn((Object)("profile.xml not found in servicearchive " + mb.getArtefactFilename()));
            }
        }
        return packages;
    }

    private static String extractWikidocLink(byte[] readmeText) {
        Pattern p = Pattern.compile(WIKIDOC_MATCHING_PATTERN);
        Matcher m = p.matcher(new String(readmeText));
        if (m.find()) {
            return m.group();
        }
        return null;
    }

    private static Map<String, String> loadModuleMappings(File moduleMappingsFilepath) throws FileNotFoundException, IOException {
        LOGGER.info((Object)("Load mappings from " + moduleMappingsFilepath));
        HashMap<String, String> res = new HashMap<String, String>();
        Properties p = new Properties();
        p.load(new FileInputStream(moduleMappingsFilepath));
        res = new HashMap();
        Set<Map.Entry<Object, Object>> entries = p.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            LOGGER.info((Object)("loading " + (String)entry.getKey() + " - " + (String)entry.getValue()));
            res.put(((String)entry.getKey()).trim(), ((String)entry.getValue()).trim());
        }
        return res;
    }

    private static void acceptProfile(byte[] profile, String artefactName, String wikidoc, Map<String, String> modulePackageMapping, Set<PackagesModuleReport> packages) throws XPathExpressionException, ReportException {
        String moduleName;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        InputSource inputSource = null;
        inputSource = new InputSource(new ByteArrayInputStream(profile));
        String serviceName = (String)xPath.evaluate("/Resource/Profile/Name", inputSource, XPathConstants.STRING);
        if (serviceName == null || serviceName.equals("")) {
            throw new ReportException("Service Name not defined in profile.xml in servicearchive " + artefactName);
        }
        inputSource = new InputSource(new ByteArrayInputStream(profile));
        String mainPackageName = (String)xPath.evaluate("/Resource/Profile/Packages/Main/Name", inputSource, XPathConstants.STRING);
        inputSource = new InputSource(new ByteArrayInputStream(profile));
        String mainPackageVersion = (String)xPath.evaluate("/Resource/Profile/Packages/Main/Version", inputSource, XPathConstants.STRING);
        if (mainPackageName != null && !mainPackageName.equals("") && (moduleName = modulePackageMapping.get(serviceName + "." + mainPackageName)) != null) {
            PackagesModuleReport pmr = new PackagesModuleReport(serviceName, mainPackageName, mainPackageVersion, artefactName, wikidoc, moduleName);
            packages.add(pmr);
        }
        inputSource = new InputSource(new ByteArrayInputStream(profile));
        NodeList softwareNodes = (NodeList)xPath.evaluate("/Resource/Profile/Packages/*[name()='Software' or name()='Plugin']", inputSource, XPathConstants.NODESET);
        for (int i = 0; i < softwareNodes.getLength(); ++i) {
            String moduleName2;
            Node softwareNode = softwareNodes.item(i);
            String packageName = null;
            String packageVersion = null;
            NodeList childsNodes = softwareNode.getChildNodes();
            for (int j = 0; j < childsNodes.getLength(); ++j) {
                String tagname = childsNodes.item(j).getNodeName();
                if (tagname.equals("Name")) {
                    packageName = childsNodes.item(j).getTextContent();
                    continue;
                }
                if (!tagname.equals("Version")) continue;
                packageVersion = childsNodes.item(j).getTextContent();
            }
            if (packageName == null || packageVersion.equals("") || (moduleName2 = modulePackageMapping.get(serviceName + "." + packageName)) == null) continue;
            PackagesModuleReport pmr = new PackagesModuleReport(serviceName, packageName, packageVersion, artefactName, wikidoc, moduleName2);
            packages.add(pmr);
        }
    }
}

