/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.report.checkstyle;

import it.eng.d4s.sa3.model.Build;
import it.eng.d4s.sa3.model.ModuleBuild;
import it.eng.d4s.sa3.report.ReportException;
import it.eng.d4s.sa3.report.checkstyle.ModuleCheckstyleReport;
import it.eng.d4s.sa3.report.checkstyle.util.CheckstyleReportGenerator;
import it.eng.d4s.sa3.repository.resourcetype.BuildResourceType;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CheckstyleReport {
    private static final Logger LOGGER = Logger.getLogger(CheckstyleReport.class);
    private Map<String, ModuleCheckstyleReport> moduleReports;

    public static CheckstyleReport getInstance(Build b) throws ReportException {
        try {
            if (b.getRepo().existsBResource(BuildResourceType.B_CHECKSTYLE_REPORT)) {
                InputStream is = b.getRepo().getBResourceIS(BuildResourceType.B_CHECKSTYLE_REPORT);
                return new CheckstyleReport(is);
            }
            CheckstyleReportGenerator.generate(b, b.getAllModuleBuilds());
            return CheckstyleReport.getInstance(b);
        }
        catch (Exception e) {
            throw new ReportException("Error loading checkStyleReport for build " + b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckstyleReport(InputStream is) throws Exception {
        try {
            Set reportData = (Set)CheckstyleReportGenerator.getConfiguratedXStream().fromXML(is);
            is.close();
            this.moduleReports = new HashMap<String, ModuleCheckstyleReport>();
            for (ModuleCheckstyleReport r : reportData) {
                this.moduleReports.put(r.getModuleName(), r);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public ModuleCheckstyleReport getReportForModule(ModuleBuild mb) {
        return this.moduleReports.get(mb.getModuleName());
    }
}

