/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools.resourcemanager.client;

import java.util.ArrayList;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.tools.resourcemanager.client.ResourceManager;
import org.gcube.tools.resourcemanager.util.ParsePropertyFile;
import org.gcube.tools.resourcemanager.util.ServiceDeployment;
import org.gcube.tools.resourcemanager.util.Util;

public class ResourceManagerClient {
    private static void printUsage() {
        System.out.println("Resource Manager Client v 1.2.0");
        System.out.println();
        System.out.println("Usage: ResourceManagerClient [options] scope RM Address [parameters...] ");
        System.out.println();
        System.out.println("where options include:");
        System.out.println();
        System.out.println("DEPLOY : to deploy one or more SAs");
        System.out.println();
        System.out.println("UNDEPLOY_RI : to undeploy one or more RunningInstance knowing the Ids.");
        System.out.println();
        System.out.println("UNDEPLOY_SA : to undeploy one or more SAs from the given scope ( useful for the upgrade operation)");
        System.out.println();
        System.out.println("UPGRADE_RI : to upgrade one or more RIs in the given scope ");
        System.out.println();
        System.out.println("UPGRADE_SA : to upgrade one or more SAs in the given scope.");
        System.out.println();
        System.out.println("ADD_SCOPE : to add one or more Resources to the given scope");
        System.out.println();
        System.out.println("REMOVE_SCOPE : to remove on or more Resources from the given scope");
        System.out.println();
        System.out.println("REPORT : to get the deployment/undeplopyment report");
        System.out.println();
        System.out.println();
        System.out.println("For each options the following parameters are needed:");
        System.out.println();
        System.out.println("DEPLOY : [<ServiceName> <ServiceClass> <version> <GHNId>]*");
        System.out.println();
        System.out.println("A property file containing the deployment information can  be provided instead:");
        System.out.println();
        System.out.println("DEPLOY : <Property File>");
        System.out.println();
        System.out.println("UNDEPLOY_RI : [<RunningIstanceID>]* ");
        System.out.println();
        System.out.println("UNDEPLOY_SA : [<ServiceName> <ServiceClass> <version> ]* <GHNId>");
        System.out.println();
        System.out.println("A property file containing the undeployment information can  be provided instead:");
        System.out.println();
        System.out.println("UNDEPLOY_SA : <Property File>");
        System.out.println();
        System.out.println("UPGRADE_RI :[<RunningIstanceID>]* ");
        System.out.println();
        System.out.println("UPGRADE_SA : [<ServiceName> <ServiceClass> <version> ]* <GHNId> ");
        System.out.println();
        System.out.println("A property file containing the upgrade information can  be provided instead:");
        System.out.println();
        System.out.println("UPGRADE_SA : <Property File>");
        System.out.println();
        System.out.println("ADD_SCOPE : <ResourceType> [<ResourceID>]* ");
        System.out.println();
        System.out.println("<ResourceType> must be one of: GHN, RunningInstance, Collection, MetadataCollection, GenericResource");
        System.out.println();
        System.out.println("REMOVE_SCOPE : <ResourceType> [<ResourceID>]* ");
        System.out.println();
        System.out.println("<ResourceType> must be one of: GHN, RunningInstance, Collection, MetadataCollection, GenericResource");
        System.out.println();
        System.out.println("REPORT : <deployment/undeployment ID>");
        System.out.println();
        System.out.println();
        System.out.println("identity:  if the ResourceManager is running in a secure infra with Authz Enabled it requires the Identity of the caller for authz porpuses, ignore otherwise");
        System.out.println();
        System.out.println("Author: Andrea Manzi <andrea.manzi@cern.ch>");
        System.out.println();
        System.out.println("Report bugs at https://support.d4science-ii.research-infrastructures.eu/");
        System.out.println();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        int n;
        ResourceManager resourceManager = null;
        GCUBEScope gCUBEScope = null;
        String string = "";
        String[] stringArray2 = null;
        try {
            if (stringArray.length < 3) {
                ResourceManagerClient.printUsage();
            }
            if (stringArray[0].trim().compareTo("/help") == 0 || stringArray[0].trim().compareTo("-help") == 0) {
                ResourceManagerClient.printUsage();
            }
            gCUBEScope = GCUBEScope.getScope((String)stringArray[1]);
            resourceManager = new ResourceManager(gCUBEScope, stringArray[2]);
            stringArray2 = new String[stringArray.length - 3];
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray2[n] = stringArray[n + 3];
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        switch (Util.Actions.valueOf(stringArray[0])) {
            case DEPLOY: {
                try {
                    ArrayList<ServiceDeployment> arrayList = new ArrayList();
                    if (stringArray2.length == 1) {
                        arrayList = new ParsePropertyFile(stringArray2[0]).getServices();
                    } else {
                        if (stringArray2.length == 0 || stringArray2.length % 4 != 0) {
                            resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                            ResourceManagerClient.printUsage();
                        }
                        for (int i = 0; i < stringArray2.length; i += 4) {
                            ServiceDeployment serviceDeployment = new ServiceDeployment();
                            serviceDeployment.setServiceName(stringArray2[i]);
                            serviceDeployment.setServiceClass(stringArray2[i + 1]);
                            serviceDeployment.setVersion(stringArray2[i + 2]);
                            serviceDeployment.setGHN(stringArray2[i + 3]);
                            arrayList.add(serviceDeployment);
                        }
                    }
                    string = resourceManager.deployServices(arrayList, gCUBEScope);
                    if (string == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Deployment");
                        System.exit(1);
                    }
                    long l = System.currentTimeMillis();
                    boolean bl = false;
                    while (!bl && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        bl = resourceManager.getDeploymentInfo().checkDeploymentInfo();
                        if (bl) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final Deployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case UNDEPLOY_RI: {
                if (stringArray2.length == 0) {
                    resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                    ResourceManagerClient.printUsage();
                }
                try {
                    long l = System.currentTimeMillis();
                    boolean bl = false;
                    resourceManager.undeployRIs(stringArray2, false);
                    if (resourceManager.getUndeploymentID() == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Undeployment");
                        System.exit(1);
                    }
                    l = System.currentTimeMillis();
                    while (!bl && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(resourceManager.getUndeploymentID(), false));
                        bl = resourceManager.getDeploymentInfo().checkUnDeploymentInfo();
                        if (bl) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final UNDeployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case UNDEPLOY_SA: {
                try {
                    int n2;
                    ArrayList<ServiceDeployment> arrayList = new ArrayList();
                    if (stringArray2.length == 1) {
                        arrayList = new ParsePropertyFile(stringArray2[0]).getServices();
                    } else {
                        if (stringArray2.length == 0 || stringArray2.length % 3 != 0 && stringArray2.length % 3 != 1) {
                            resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                            ResourceManagerClient.printUsage();
                        }
                        String string2 = null;
                        int n3 = stringArray2.length;
                        if (stringArray2.length % 3 == 1) {
                            string2 = stringArray2[stringArray2.length - 1];
                            n3 = stringArray2.length - 1;
                        }
                        for (n2 = 0; n2 < n3; n2 += 3) {
                            ServiceDeployment serviceDeployment = new ServiceDeployment();
                            serviceDeployment.setServiceName(stringArray2[n2]);
                            serviceDeployment.setServiceClass(stringArray2[n2 + 1]);
                            serviceDeployment.setVersion(stringArray2[n2 + 2]);
                            if (stringArray2.length % 3 == 1) {
                                serviceDeployment.setGHN(string2);
                            }
                            arrayList.add(serviceDeployment);
                        }
                    }
                    string = resourceManager.undeploySAs(arrayList, gCUBEScope);
                    if (string == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Undeployment");
                        System.exit(1);
                    }
                    long l = System.currentTimeMillis();
                    n2 = 0;
                    while (n2 == 0 && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        n2 = resourceManager.getDeploymentInfo().checkUnDeploymentInfo() ? 1 : 0;
                        if (n2 != 0) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final UnDeployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case UPGRADE_RI: {
                if (stringArray2.length == 0) {
                    resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                    ResourceManagerClient.printUsage();
                }
                ArrayList<ServiceDeployment> arrayList = new ArrayList();
                try {
                    arrayList = resourceManager.undeployRIs(stringArray2, true);
                    if (resourceManager.getUndeploymentID() == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Undeployment");
                        System.exit(1);
                    }
                    long l = System.currentTimeMillis();
                    boolean bl = false;
                    while (!bl && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(resourceManager.getUndeploymentID(), false));
                        bl = resourceManager.getDeploymentInfo().checkUnDeploymentInfo();
                        if (bl) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (!resourceManager.getDeploymentInfo().isGlobaloperationStatus()) {
                        resourceManager.logger.error((Object)"The undeployment operation has failed");
                        System.exit(1);
                    }
                    if (System.currentTimeMillis() - l > (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.logger.error((Object)("Unable to get a Final UnDeployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                        System.exit(1);
                    }
                    Thread.sleep(30000L);
                    string = resourceManager.deployServices(arrayList, gCUBEScope);
                    if (string == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Deployment");
                        System.exit(1);
                    }
                    l = System.currentTimeMillis();
                    bl = false;
                    while (!bl && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        bl = resourceManager.getDeploymentInfo().checkDeploymentInfo();
                        if (bl) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (!resourceManager.getDeploymentInfo().isGlobaloperationStatus()) {
                        resourceManager.logger.error((Object)"The upgrade operation has failed");
                        System.exit(1);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final Deployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case UPGRADE_SA: {
                ArrayList<ServiceDeployment> arrayList = new ArrayList();
                try {
                    int n4;
                    if (stringArray2.length == 1) {
                        arrayList = new ParsePropertyFile(stringArray2[0]).getServices();
                    } else {
                        if (stringArray2.length == 0 || stringArray2.length % 3 != 0 && stringArray2.length % 3 != 1) {
                            resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                            ResourceManagerClient.printUsage();
                        }
                        String string3 = null;
                        int n5 = stringArray2.length;
                        if (stringArray2.length % 3 == 1) {
                            string3 = stringArray2[stringArray2.length - 1];
                            n5 = stringArray2.length - 1;
                        }
                        for (n4 = 0; n4 < n5; n4 += 3) {
                            ServiceDeployment serviceDeployment = new ServiceDeployment();
                            serviceDeployment.setServiceName(stringArray2[n4]);
                            serviceDeployment.setServiceClass(stringArray2[n4 + 1]);
                            serviceDeployment.setVersion(stringArray2[n4 + 2]);
                            if (stringArray2.length % 3 == 1) {
                                serviceDeployment.setGHN(string3);
                            }
                            arrayList.add(serviceDeployment);
                        }
                    }
                    Thread.sleep(30000L);
                    string = resourceManager.undeploySAs(arrayList, gCUBEScope);
                    if (string == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Undeployment");
                        System.exit(1);
                    }
                    long l = System.currentTimeMillis();
                    n4 = 0;
                    while (n4 == 0 && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        n4 = resourceManager.getDeploymentInfo().checkUnDeploymentInfo() ? 1 : 0;
                        if (n4 != 0) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l > (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.logger.error((Object)("Unable to get a Final UnDeployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                        System.exit(1);
                    }
                    if ((string = resourceManager.deployServices(arrayList, gCUBEScope)) == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform Deployment");
                        System.exit(1);
                    }
                    l = System.currentTimeMillis();
                    n4 = 0;
                    while (n4 == 0 && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        n4 = resourceManager.getDeploymentInfo().checkDeploymentInfo() ? 1 : 0;
                        if (n4 != 0) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final Deployment Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case ADD_SCOPE: {
                try {
                    if (stringArray2.length < 2) {
                        resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                        ResourceManagerClient.printUsage();
                    }
                    stringArray2 = new String[stringArray.length - 4];
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray2[n] = stringArray[n + 4];
                    }
                    string = resourceManager.addScope(stringArray2, stringArray[3], gCUBEScope);
                    if (string == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform the operation");
                        System.exit(1);
                    }
                    long l = System.currentTimeMillis();
                    boolean bl = false;
                    while (!bl && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        bl = resourceManager.getDeploymentInfo().checkOperationInfo();
                        if (bl) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final Operation Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case REMOVE_SCOPE: {
                try {
                    if (stringArray2.length < 2) {
                        resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                        ResourceManagerClient.printUsage();
                    }
                    stringArray2 = new String[stringArray.length - 4];
                    for (n = 0; n < stringArray2.length; ++n) {
                        stringArray2[n] = stringArray[n + 4];
                    }
                    string = resourceManager.removeScope(stringArray2, stringArray[3], gCUBEScope);
                    if (string == null) {
                        resourceManager.logger.error((Object)"Unable to connect to Resource Manager to perform the operation");
                        System.exit(1);
                    }
                    long l = System.currentTimeMillis();
                    boolean bl = false;
                    while (!bl && System.currentTimeMillis() - l < (long)resourceManager.resourceManagerDelayMs) {
                        resourceManager.getDeploymentInfo().parseXml(resourceManager.getReport(string, false));
                        bl = resourceManager.getDeploymentInfo().checkOperationInfo();
                        if (bl) continue;
                        Thread.sleep(resourceManager.resourceManagerReportDelayMs);
                    }
                    if (System.currentTimeMillis() - l <= (long)resourceManager.resourceManagerDelayMs) break;
                    resourceManager.logger.error((Object)("Unable to get a Final Operation Report after:" + resourceManager.resourceManagerDelayMs / 1000 + " s"));
                    System.exit(1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case REPORT: {
                try {
                    if (stringArray2.length < 1) {
                        resourceManager.logger.error((Object)"Please check the syntaxt. Incorrect number of parameters");
                        ResourceManagerClient.printUsage();
                    }
                    string = resourceManager.getReport(stringArray[2], true);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.exit(1);
                }
            }
        }
        System.exit(0);
    }
}

