/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.contextmanager;

import java.util.List;
import javax.xml.bind.JAXBException;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.vremanagement.contextmanager.MultiKeysMap;
import org.gcube.vremanagement.contextmanager.ResourceBinder;
import org.gcube.vremanagement.contextmanager.ScopeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAppManager
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(ContextAppManager.class);
    MultiKeysMap<String, String, ScopeDescriptor> scopeDescriptorMap = new MultiKeysMap();

    public void onInit() {
        String currentContext = ScopeProvider.instance.get();
        logger.info("resource initialization started in {} ", (Object)currentContext);
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text eq 'VRE' or $resource/Profile/SecondaryType/text eq 'VO'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)query);
        for (GenericResource resource : resources) {
            try {
                String body = resource.profile().bodyAsString();
                ScopeDescriptor scopeDescr = ResourceBinder.get().bind(body);
                this.scopeDescriptorMap.put((Object)scopeDescr.context, (Object)resource.id(), (Object)scopeDescr);
            }
            catch (JAXBException e) {
                logger.error("cannot unmarshal resource", (Throwable)e);
            }
        }
    }

    public void onShutdown() {
    }

    public MultiKeysMap<String, String, ScopeDescriptor> getScopeDescriptorMap() {
        return this.scopeDescriptorMap;
    }
}

