/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.contextmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.vremanagement.contextmanager.MultiKeysMap;

public class MultiKeysMap<K1, K2, V>
implements Iterable<V> {
    private List<V> values = Collections.synchronizedList(new LinkedList());
    private List<WrappedValue> wrappedValues = Collections.synchronizedList(new LinkedList());
    private Map<K1, HashSet<V>> k1values = Collections.synchronizedMap(new HashMap());
    private Map<K2, HashSet<V>> k2values = Collections.synchronizedMap(new HashMap());

    @Override
    public Iterator<V> iterator() {
        return this.values.iterator();
    }

    public void put(K1 key1, K2 key2, V value) {
        WrappedValue wrappedValue = new WrappedValue(this, value);
        wrappedValue.addKey1(key1);
        wrappedValue.addKey2(key2);
        if (this.wrappedValues.contains(wrappedValue)) {
            this.wrappedValues.remove(wrappedValue);
        }
        this.wrappedValues.add(wrappedValue);
        if (this.values.contains(value)) {
            this.values.remove(value);
        }
        this.values.add(value);
        if (!this.k1values.containsKey(key1)) {
            this.k1values.put(key1, new HashSet());
        }
        ((HashSet)this.k1values.get(key1)).add(value);
        if (!this.k2values.containsKey(key2)) {
            this.k2values.put(key2, new HashSet());
        }
        ((HashSet)this.k2values.get(key2)).add(value);
    }

    public void removeValue(V value) {
        this.values.remove(value);
        WrappedValue wvalue = (WrappedValue)this.wrappedValues.get(this.wrappedIndexOf(value));
        ((HashSet)this.k1values.get(wvalue.key1)).remove(value);
        if (((HashSet)this.k1values.get(wvalue.key1)).isEmpty()) {
            this.k1values.remove(wvalue.key1);
        }
        ((HashSet)this.k2values.get(wvalue.key2)).remove(value);
        if (((HashSet)this.k2values.get(wvalue.key2)).isEmpty()) {
            this.k2values.remove(wvalue.key2);
        }
        this.wrappedValues.remove(wvalue);
    }

    public void removeValuesByPrimaryKey(K1 key) {
        Set valuesToRemove = (Set)this.k1values.get(key);
        if (valuesToRemove == null) {
            return;
        }
        for (Object value : valuesToRemove) {
            this.values.remove(value);
            if (value == null) continue;
            WrappedValue wvalue = (WrappedValue)this.wrappedValues.get(this.wrappedIndexOf(value));
            ((HashSet)this.k2values.get(wvalue.key2)).remove(value);
            if (((HashSet)this.k2values.get(wvalue.key2)).isEmpty()) {
                this.k2values.remove(wvalue.key2);
            }
            this.wrappedValues.remove(wvalue);
        }
        this.k1values.remove(key);
    }

    public void removeValuesBySecondaryKey(K2 key) {
        Set valuesToRemove = (Set)this.k2values.get(key);
        if (valuesToRemove == null) {
            return;
        }
        for (Object value : valuesToRemove) {
            this.values.remove(value);
            if (value == null) {
                return;
            }
            WrappedValue wvalue = (WrappedValue)this.wrappedValues.get(this.wrappedIndexOf(value));
            ((HashSet)this.k1values.get(wvalue.key1)).remove(value);
            if (((HashSet)this.k1values.get(wvalue.key1)).isEmpty()) {
                this.k1values.remove(wvalue.key1);
            }
            this.wrappedValues.remove(wvalue);
        }
        this.k2values.remove(key);
    }

    private int wrappedIndexOf(V value) {
        int index = 0;
        if (value == null) {
            return -1;
        }
        for (WrappedValue wvalue : this.wrappedValues) {
            if (wvalue.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Set<V> getValuesByPrimaryKey(K1 key) {
        return this.k1values.get(key) == null ? Collections.emptySet() : (Set)this.k1values.get(key);
    }

    public Set<V> getValuesBySecondaryKey(K2 key) {
        return this.k2values.get(key) == null ? Collections.emptySet() : (Set)this.k2values.get(key);
    }

    public Set<K1> primaryKeySet() {
        return this.k1values.keySet() == null ? Collections.emptySet() : this.k1values.keySet();
    }

    public Set<K2> secondaryKeySet() {
        return this.k2values.keySet() == null ? Collections.emptySet() : this.k2values.keySet();
    }

    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.values);
    }

    public void clean() {
        this.values.clear();
        this.wrappedValues.clear();
        this.k1values.clear();
        this.k2values.clear();
    }
}

