/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.contextmanager;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;

public final class ProfileDate {
    static final DateFormat dateAndTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public static synchronized String toXMLDateAndTime(Date date) {
        String formatted = dateAndTime.format(date);
        StringBuilder toXS = new StringBuilder();
        toXS.append(formatted.substring(0, formatted.length() - 2));
        toXS.append(":");
        toXS.append(formatted.substring(formatted.length() - 2, formatted.length()));
        return toXS.toString();
    }

    public static synchronized Date fromXMLDateAndTime(String date) throws ParseException {
        Pattern p = Pattern.compile("^.*T\\d{2}:\\d{2}:\\d{2}$");
        if (p.matcher(date).matches()) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(date);
        }
        StringBuilder toDate = new StringBuilder();
        toDate.append(date.substring(0, date.length() - 3));
        toDate.append(date.substring(date.length() - 2, date.length()));
        return dateAndTime.parse(toDate.toString());
    }
}

