/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.contextmanager.services;

import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.contextmanager.ContextAppManager;
import org.gcube.vremanagement.contextmanager.ResourceManager;
import org.gcube.vremanagement.contextmanager.handlers.ContextHandler;
import org.gcube.vremanagement.contextmanager.model.types.ContextList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="contexts")
@ManagedBy(value=ContextAppManager.class)
public class ContextService {
    private static Logger log = LoggerFactory.getLogger(ContextService.class);
    ApplicationContext appContext = ContextProvider.get();
    @Inject
    ContextHandler contextHandler;
    @Inject
    ResourceManager resourceHandler;
    @RequestScoped
    @PathParam(value="vre")
    String vre;
    @RequestScoped
    @PathParam(value="resourceId")
    String resourceId;
    @RequestScoped
    @PathParam(value="infra")
    String infra;
    @RequestScoped
    @PathParam(value="vo")
    String vo;

    @GET
    @Produces(value={"application/json"})
    @Path(value="")
    public ContextList getContexts() {
        return new ContextList(Arrays.asList("/gcube", "/gcube/devsec"));
    }

    @PUT
    @Path(value="/{infra}/{vo}/{vre}")
    public String createVREContext(List<String> resourceIds) {
        try {
            String fullContext = String.format("/%s/%s/%s", this.infra, this.vo, this.vre);
            this.validateCall(fullContext);
            this.contextHandler.createContext(fullContext, resourceIds, (ContextAppManager)ApplicationManagerProvider.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @DELETE
    @Path(value="/{infra}/{vo}/{vre}")
    public String disposeVREContext() {
        try {
            String fullContext = String.format("/%s/%s/%s", this.infra, this.vo, this.vre);
            this.validateCall(fullContext);
            this.contextHandler.removeContext(fullContext, (ContextAppManager)ApplicationManagerProvider.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @DELETE
    @Path(value="/{context:(.*(?=/resources))}/resources/{resourceId}")
    public String removeResourceFromContext(@PathParam(value="context") String context) {
        log.info("remove resource {} from context {}", (Object)this.resourceId, (Object)context);
        try {
            this.validateCall(context);
            this.resourceHandler.removeResourceFromContext(context, this.resourceId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @PUT
    @Path(value="/{context:(.*(?=/resources))}/resources")
    public String addResourceToContext(@PathParam(value="context") String context, Resource resource) {
        log.info("adding resource {} to context {}", (Object)resource.id(), (Object)context);
        try {
            this.validateCall(context);
            this.resourceHandler.addResourceToContext(context, resource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void validateCall(String fullContext) throws Exception {
        String currentContext = ScopeProvider.instance.get();
        if (!fullContext.startsWith(currentContext)) {
            throw new Exception("invalid call");
        }
    }
}

