package org.gcube.vremanagement.contextmanager.model.collectors;

import java.util.List;

import org.gcube.common.resources.gcore.Resource;

public interface BackendConnector {

	Resource find(String resourceId);
	
	String createContext(String contextName, String parentContextId, List<String> resourceIds);
	
	boolean removeContext(String contextId);
	
	boolean addResourceToContext(String contextId, Resource resource);
	
	boolean removeResourceFromContext(String contextId, Resource resource);
	
	boolean updateResource(Resource resource);
	
}
