/**
 * 
 */
package org.gcube.vremanagement.executor.api.types;

import java.util.Map;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import org.gcube.vremanagement.executor.api.types.adapter.MapAdapter;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
@XmlRootElement()
@XmlAccessorType(XmlAccessType.FIELD)
public class LaunchParameter {

	@XmlElement
	private String name;
	
	@XmlJavaTypeAdapter(MapAdapter.class)
	private Map<String, Object> inputs;

	@SuppressWarnings("unused")
	private LaunchParameter(){}
	
	/**
	 * @param name
	 * @param inputs
	 */
	public LaunchParameter(String name, Map<String, Object> inputs) {
		this.name = name;
		this.inputs = inputs;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @return the inputs
	 */
	public Map<String, Object> getInputs() {
		return inputs;
	}
	
}
