/**
 * 
 */
package org.gcube.vremanagement.executor.persistence;

import java.util.UUID;

import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginState;

/**
 * Model the connector which create or open the connection to DB 
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public abstract class PersistenceConnector {
	
	/**
	 * Default Constructor
	 */
	public PersistenceConnector(){
		
	}

	
	/**
	 * This constructor is used to provide a location where creating persistence
	 * files
	 * @param location directory where creating the DB file
	 */
	public PersistenceConnector(String location) {}


	/**
	 * Close the connection to DB
	 * @throws Exception if fails
	 */
	public abstract void close() throws Exception;
	
	/**
	 * Retrieve the status a running/run {@link Plugin} which is/was identified 
	 * by the UUID passed as parameter
	 * @param uuid the execution identifier of the running/run {@link Plugin}
	 * @return the actual/last {@link PluginState} of the Plugin
	 * @throws Exception if fails
	 */
	public abstract PluginState getPluginInstanceState(UUID uuid)
			throws Exception;

}
