package org.gcube.vremanagement.executor.api.rest;

import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;

public interface SmartExecutor {
	
	public static final String ORPHAN_PATH_PARAM = "ORPHAN";
	
	public String getAvailablePlugins() throws ExecutorException;
	
	public String getScheduled(String pluginName) throws ExecutorException;
	
	public String launch(String pluginName, String launchParameterString) throws ExecutorException;
	
	public String getLaunchState(String pluginName, String executionIdentifier, Integer iteration)
			throws PluginInstanceNotFoundException, ExecutorException;
	
	public boolean delete(String pluginName, String executionIdentifier, Boolean unschedule) throws ExecutorException;
	
	public boolean purge(String pluginName, String executionIdentifier) throws ExecutorException;
	
}
