/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.plugin;

import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.vremanagement.executor.exception.InvalidPluginStateEvolutionException;
import org.gcube.vremanagement.executor.plugin.PluginDefinition;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.RunOn;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class PluginStateEvolution {
    protected UUID uuid;
    protected int iteration;
    protected long timestamp;
    protected PluginDefinition pluginDefinition;
    protected PluginState pluginState;
    protected int percentage;
    protected RunOn runOn;

    public PluginStateEvolution() {
    }

    public PluginStateEvolution(UUID uuid, int iteration, long timestamp, PluginDefinition pluginDefinition, PluginState pluginState, Integer percentage) throws InvalidPluginStateEvolutionException {
        this.uuid = uuid;
        this.iteration = iteration;
        this.timestamp = timestamp;
        this.pluginDefinition = pluginDefinition;
        this.pluginState = pluginState;
        switch (pluginState) {
            case CREATED: {
                this.percentage = 0;
                break;
            }
            default: {
                if (percentage < 0 || percentage > 100) {
                    throw new InvalidPluginStateEvolutionException("Percentage must be beetween 0 and 100");
                }
                this.percentage = percentage;
            }
        }
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getIteration() {
        return this.iteration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @JsonGetter
    public PluginDefinition getPluginDefinition() {
        return this.pluginDefinition;
    }

    public PluginState getPluginState() {
        return this.pluginState;
    }

    public Integer getPercentage() {
        return this.percentage;
    }

    protected RunOn getRunOn() {
        return this.runOn;
    }

    protected void setRunOn(RunOn runOn) {
        this.runOn = runOn;
    }

    public String toString() {
        return String.format("{uuid:%s,iteration:%d,timestamp:%d,pluginDefinition:%s,pluginState:%s,percentage:%d}", new Object[]{this.uuid, this.iteration, this.timestamp, this.pluginDefinition, this.pluginState, this.percentage});
    }
}

