/**
 * 
 */
package org.gcube.vremanagement.executor.plugin;

import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.vremanagement.executor.json.SEMapper;

@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property=SEMapper.CLASS_PROPERTY)
@JsonTypeName(value="Ref")
/**
 * Reference class that holds an ID and address pair.
 * Used to represent references to various entities in the system.
 * @author Luca Frosini (ISTI - CNR)
 */
public class Ref {

	/** The identifier */
	@JsonProperty
	protected String id;
	
	/** The address or location */
	@JsonProperty
	protected String address;
	
	/**
	 * Protected default constructor for serialization.
	 */
	protected Ref() {}
	
	/**
	 * Constructor with id and address.
	 * @param id the identifier
	 * @param address the address or location
	 */
	public Ref(String id, String address) {
		super();
		this.id = id;
		this.address = address;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the address
	 */
	public String getAddress() {
		return address;
	}

	/**
	 * @param address the address to set
	 */
	public void setAddress(String address) {
		this.address = address;
	}
	
	
	
}