/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client;

import java.util.UUID;
import org.gcube.vremanagement.executor.api.rest.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.plugins.ExecutorPlugin;
import org.gcube.vremanagement.executor.client.plugins.query.SmartExecutorPluginQuery;
import org.gcube.vremanagement.executor.client.proxies.SmartExecutorProxy;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;

class SmartExecutorClientSOAPWrapper
implements SmartExecutor {
    public static final String PATH_SEPARATOR = "/";
    protected SmartExecutorProxy smartExecutorProxy;

    public SmartExecutorClientSOAPWrapper(SmartExecutorProxy smartExecutorProxy) {
        this.smartExecutorProxy = smartExecutorProxy;
    }

    public SmartExecutorClientSOAPWrapper(SmartExecutorPluginQuery query, ExecutorPlugin executorPlugin) {
        this.smartExecutorProxy = (SmartExecutorProxy)ExecutorPlugin.getExecutorProxy(query, executorPlugin).build();
    }

    public String launch(String launchParameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        try {
            LaunchParameter lp = (LaunchParameter)SEMapper.unmarshal(LaunchParameter.class, (String)launchParameter);
            try {
                return this.smartExecutorProxy.launch(lp);
            }
            catch (Exception e) {
                throw (Exception)e.getCause();
            }
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID launch(LaunchParameter launchParameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        try {
            String uuid = this.smartExecutorProxy.launch(launchParameter);
            return UUID.fromString(uuid);
        }
        catch (Exception e) {
            try {
                throw (Exception)e.getCause();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPluginStateEvolution(String executionIdentifier, Integer iterationNumber) throws ExecutorException {
        try {
            PluginStateEvolution pluginStateEvolution = null;
            if (iterationNumber != null) {
                pluginStateEvolution = this.smartExecutorProxy.getIterationStateEvolution(executionIdentifier, iterationNumber);
                return SEMapper.marshal((Object)pluginStateEvolution);
            }
            pluginStateEvolution = this.smartExecutorProxy.getStateEvolution(executionIdentifier);
            return SEMapper.marshal((Object)pluginStateEvolution);
        }
        catch (Exception e) {
            try {
                throw (Exception)e.getCause();
            }
            catch (Exception e2) {
                throw new ExecutorException((Throwable)e2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PluginStateEvolution getPluginStateEvolution(UUID executionIdentifier, Integer iterationNumber) throws ExecutorException {
        try {
            PluginStateEvolution pluginStateEvolution = null;
            if (iterationNumber == null) return this.smartExecutorProxy.getStateEvolution(executionIdentifier.toString());
            return this.smartExecutorProxy.getIterationStateEvolution(executionIdentifier.toString(), iterationNumber);
        }
        catch (Exception e) {
            try {
                throw (Exception)e.getCause();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public boolean delete(String executionIdentifier, boolean globally) throws ExecutorException {
        return this.smartExecutorProxy.unSchedule(executionIdentifier, globally);
    }

    public boolean delete(UUID executionIdentifier, boolean globally) throws ExecutorException {
        return this.delete(executionIdentifier.toString(), globally);
    }
}

