/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.client.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.client.plugins.query.filter.EndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.SpecificEndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.query.filter.GCoreEndpointQueryFilter;
import org.gcube.vremanagement.executor.client.query.filter.ServiceEndpointQueryFilter;
import org.gcube.vremanagement.executor.client.util.Tuple;

public class Discover {
    private static String classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
    private static String nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
    private static String statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
    protected String containsFormat;
    protected final String entryName;
    private final SimpleQuery serviceEndpointQuery;
    protected org.gcube.vremanagement.executor.client.plugins.query.filter.ServiceEndpointQueryFilter serviceEndpointQueryFilter;
    protected EndpointDiscoveryFilter endpointDiscoveryFilter;

    protected SimpleQuery getGCoreEndpointQuery() {
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, "VREManagement")).addCondition(String.format(nameFormat, "SmartExecutor")).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(this.containsFormat, this.entryName)).setResult("$entry/text()");
    }

    public Discover(String entryName) {
        this.entryName = entryName;
        this.serviceEndpointQuery = ICFactory.queryFor(ServiceEndpoint.class).addCondition(String.format("$resource/Profile/Category/text() eq '%s'", "VREManagement")).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", "SmartExecutor")).setResult("$resource");
        this.containsFormat = "$entry/@EntryName eq '%1s'";
    }

    public void filterByPluginName(String pluginName) {
        this.serviceEndpointQuery.addVariable("$accessPoint", "$resource/Profile/AccessPoint").addCondition(String.format("$accessPoint/Interface/Endpoint/@EntryName eq '%s'", pluginName));
    }

    public void filterByCapabilities(Map<String, String> capabilities) {
        if (capabilities != null && !capabilities.isEmpty()) {
            int i = 0;
            for (String key : capabilities.keySet()) {
                String propertyVariableName = String.format("$property%d", i);
                this.serviceEndpointQuery.addVariable(propertyVariableName, "$accessPoint/Properties/Property").addCondition(String.format("%s/Name/text() eq '%s'", propertyVariableName, key)).addCondition(String.format("%s/Value/text() eq '%s'", propertyVariableName, capabilities.get(key)));
                ++i;
            }
        }
    }

    @Deprecated
    public void addConditions(String pluginName, Tuple<String, String> ... tuples) {
        this.filterByPluginName(pluginName);
        if (tuples == null) {
            return;
        }
        HashMap<String, String> capabilities = new HashMap<String, String>();
        for (int i = 0; i < tuples.length; ++i) {
            capabilities.put(tuples[i].getName(), tuples[i].getValue());
        }
    }

    public void setServiceEndpointQueryFilter(ServiceEndpointQueryFilter serviceEndpointQueryFilter) {
        this.serviceEndpointQueryFilter = serviceEndpointQueryFilter;
    }

    @Deprecated
    public void setServiceEndpointQueryFilter(org.gcube.vremanagement.executor.client.plugins.query.filter.ServiceEndpointQueryFilter serviceEndpointQueryFilter) {
        this.serviceEndpointQueryFilter = serviceEndpointQueryFilter;
    }

    public void setGCoreEndpointQueryFilter(GCoreEndpointQueryFilter gCoreEndpointQueryFilter) {
        if (gCoreEndpointQueryFilter != null) {
            this.endpointDiscoveryFilter = gCoreEndpointQueryFilter;
        }
    }

    @Deprecated
    public void setEndpointDiscoveryFilter(EndpointDiscoveryFilter endpointDiscoveryFilter) {
        if (endpointDiscoveryFilter != null) {
            this.endpointDiscoveryFilter = endpointDiscoveryFilter;
        }
    }

    @Deprecated
    public List<String> discoverEndpoints(EndpointDiscoveryFilter endpointDiscoveryFilter) throws DiscoveryException {
        List serviceEndpoints;
        if (this.serviceEndpointQueryFilter != null) {
            this.serviceEndpointQueryFilter.filter(this.serviceEndpointQuery);
        }
        if ((serviceEndpoints = ICFactory.clientFor(ServiceEndpoint.class).submit((Query)this.serviceEndpointQuery)).size() == 0) {
            throw new DiscoveryException("No running SmartExecutor wich match the requested conditions");
        }
        SimpleQuery gCoreEndpointQuery = this.getGCoreEndpointQuery();
        endpointDiscoveryFilter.filter(gCoreEndpointQuery, serviceEndpoints);
        return ICFactory.client().submit((Query)gCoreEndpointQuery);
    }

    public List<String> getAddresses() throws DiscoveryException {
        List serviceEndpoints;
        if (this.serviceEndpointQueryFilter != null) {
            this.serviceEndpointQueryFilter.filter(this.serviceEndpointQuery);
        }
        if ((serviceEndpoints = ICFactory.clientFor(ServiceEndpoint.class).submit((Query)this.serviceEndpointQuery)).size() == 0) {
            throw new DiscoveryException("No running SmartExecutor wich match the requested conditions");
        }
        SimpleQuery gCoreEndpointDiscoveryQuery = this.getGCoreEndpointQuery();
        if (this.endpointDiscoveryFilter == null) {
            Random random = new Random();
            int index = random.nextInt(serviceEndpoints.size());
            ServiceEndpoint serviceEndpoint = (ServiceEndpoint)serviceEndpoints.get(index);
            this.endpointDiscoveryFilter = new SpecificEndpointDiscoveryFilter(serviceEndpoint.profile().runtime().hostedOn());
        }
        this.endpointDiscoveryFilter.filter(gCoreEndpointDiscoveryQuery, serviceEndpoints);
        List addresses = ICFactory.client().submit((Query)gCoreEndpointDiscoveryQuery);
        return addresses;
    }
}

