/**
 * 
 */
package org.gcube.vremanagement.executor;

import java.util.List;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class SmartContextServletListener implements ServletContextListener {

	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(SmartContextServletListener.class);
	
	/**{@inheritDoc}*/
	@Override
	public void contextDestroyed(ServletContextEvent servletContextEvent) {
		logger.debug("Bye Bye SmartExecutor");
	}

	/**{@inheritDoc}*/
	@Override
	public void contextInitialized(ServletContextEvent servletContextEvent) {
		logger.debug("Hello SmartExecutor");
		ApplicationContext ctx = ContextProvider.get();
		logger.debug(String.format("ApplicationContext %s", ctx));
		if(ctx!=null){
			List<String> scopes = SmartExecutorInitalizator.getScopes(ctx);
			logger.debug(String.format("Scopes %s", scopes));
		}
	}
	
}
