/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.UUID;
import javax.jws.WebService;
import org.gcube.vremanagement.executor.SmartExecutorInitalizator;
import org.gcube.vremanagement.executor.api.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.persistence.JDBCPersistence;
import org.gcube.vremanagement.executor.persistence.JDBCPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.Persistence;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.pluginmanager.PluginThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="SmartExecutorPort", serviceName="gcube/vremanagement/smart-executor", targetNamespace="http://gcube-system.org/", endpointInterface="org.gcube.vremanagement.executor.api.SmartExecutor")
public class SmartExecutorImpl
implements SmartExecutor {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorImpl.class);

    public String launch(LaunchParameter parameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        Plugin instantiatedPlugin;
        Constructor executorPluginConstructor;
        Map inputs = parameter.getInputs();
        if (inputs == null) {
            throw new InputsNullException();
        }
        String name = parameter.getName();
        logger.debug(String.format("Trying to instatiate a Plugin named %s", name));
        PluginDeclaration pluginDeclaration = PluginManager.getInstance().getPlugin(name);
        if (pluginDeclaration == null) {
            throw new PluginNotFoundException();
        }
        UUID executionIdentifier = UUID.randomUUID();
        Class plugin = pluginDeclaration.getPluginImplementation();
        logger.debug(String.format("The class wich will run the execution will be %s", plugin.getName()));
        Class[] argTypes = new Class[]{pluginDeclaration.getClass(), Persistence.class};
        logger.debug(String.format("Plugin named %s once instatiated will be identified by the UUID %s", name, executionIdentifier));
        try {
            executorPluginConstructor = plugin.getDeclaredConstructor(argTypes);
        }
        catch (Exception e) {
            throw new LaunchException();
        }
        JDBCPersistenceConnector jdbcPersistenceConnector = SmartExecutorInitalizator.getJdbcPersistenceConnector();
        JDBCPersistence jdbcEvolutionPersistence = new JDBCPersistence(jdbcPersistenceConnector, name, executionIdentifier);
        Object[] arguments = new Object[]{pluginDeclaration, jdbcEvolutionPersistence};
        try {
            instantiatedPlugin = (Plugin)executorPluginConstructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new LaunchException();
        }
        logger.debug(String.format("Plugin named %s identified by the UUID %s has been instantiated", name, executionIdentifier));
        PluginThread pluginThread = new PluginThread(instantiatedPlugin, inputs, executionIdentifier);
        SmartExecutorInitalizator.getPluginInstances().put(executionIdentifier, pluginThread);
        SmartExecutorInitalizator.getPool().execute((Runnable)pluginThread);
        logger.debug(String.format("The Plugin named %s with UUID %s has been launched with the provided inputs", name, executionIdentifier));
        return executionIdentifier.toString();
    }

    public PluginState getState(String executionIdentifier) throws PluginInstanceNotFoundException, ExecutorException {
        try {
            JDBCPersistenceConnector jdbcPersistenceConnector = SmartExecutorInitalizator.getJdbcPersistenceConnector();
            return jdbcPersistenceConnector.getPluginInstanceState(UUID.fromString(executionIdentifier));
        }
        catch (Exception e) {
            throw new PluginInstanceNotFoundException();
        }
    }
}

