/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.gcube.vremanagement.executor.persistence.PersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCPersistenceConnector
extends PersistenceConnector {
    private static Logger logger = LoggerFactory.getLogger(JDBCPersistenceConnector.class);
    protected Connection connection;
    public static final String driverClass = "org.h2.Driver";
    public static final String jdbcConnection = "jdbc:h2:";
    public static final String username = "username";
    public static final String password = "password";
    public static final String dbName = "executor";
    public static final String PLUGIN_INSTANCE_EVOLUTION_TABLE = "PluginInstanceEvolution";
    public static final String PLUGIN_INSTANCE_EVOLUTION_TABLE_ID_FIELD = "id";
    public static final String PLUGIN_INSTANCE_EVOLUTION_TABLE_UUID_FIELD = "uuid";
    public static final String PLUGIN_INSTANCE_EVOLUTION_TABLE_PLUGIN_NAME_FIELD = "pluginName";
    public static final String PLUGIN_INSTANCE_EVOLUTION_TABLE_TIMESTAMP_FIELD = "timestamp";
    public static final String PLUGIN_INSTANCE_EVOLUTION_TABLE_STATE_FIELD = "state";
    public static final String CATALINA_HOME = "CATALINA_HOME";

    private JDBCPersistenceConnector() {
    }

    public JDBCPersistenceConnector(String location) throws Exception {
        super(location);
        try {
            Class.forName(driverClass);
            logger.debug(String.format("JDBC Driver (%s) Registered!", driverClass));
        }
        catch (ClassNotFoundException e) {
            logger.error(String.format("Driver Class (%s) NOT available : %s", driverClass, e));
            throw e;
        }
        String dbFilePath = String.format("%s/%s", location, dbName);
        String jdbcURL = String.format("%s%s", jdbcConnection, dbFilePath);
        logger.debug(String.format("DB URL : %s", jdbcURL));
        try {
            this.connection = DriverManager.getConnection(jdbcURL, username, password);
        }
        catch (SQLException e) {
            logger.error(String.format("Unable to connect to JDBC URL : %s", jdbcURL));
        }
        try {
            this.connection.setAutoCommit(false);
            String createTable = String.format("CREATE TABLE IF NOT EXISTS `%s` (`%s` INT PRIMARY KEY AUTO_INCREMENT NOT NULL,`%s` VARCHAR(36) NOT NULL,`%s` VARCHAR(255) NOT NULL,`%s` BIGINT NOT NULL,`%s` INT NOT NULL);", PLUGIN_INSTANCE_EVOLUTION_TABLE, PLUGIN_INSTANCE_EVOLUTION_TABLE_ID_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE_UUID_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE_PLUGIN_NAME_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE_TIMESTAMP_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE_STATE_FIELD);
            logger.info(String.format("Creating %s Table : %s.", PLUGIN_INSTANCE_EVOLUTION_TABLE, createTable));
            Statement createTableStatement = this.connection.createStatement();
            createTableStatement.execute(createTable);
            this.connection.commit();
        }
        catch (Exception e) {
            logger.error("Error while creating DB", (Throwable)e);
            throw e;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public PluginState getPluginInstanceState(UUID uuid) throws Exception {
        String query = String.format("SELECT `%s`,`%s` FROM `%s` WHERE `%s`=? ORDER BY `%s` DESC LIMIT 1", PLUGIN_INSTANCE_EVOLUTION_TABLE_TIMESTAMP_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE_STATE_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE, PLUGIN_INSTANCE_EVOLUTION_TABLE_UUID_FIELD, PLUGIN_INSTANCE_EVOLUTION_TABLE_TIMESTAMP_FIELD);
        logger.debug(query);
        PreparedStatement ps = this.connection.prepareStatement(query);
        ps.setString(1, uuid.toString());
        ResultSet resultSet = ps.executeQuery();
        resultSet.first();
        int stateOrdinal = resultSet.getInt(PLUGIN_INSTANCE_EVOLUTION_TABLE_STATE_FIELD);
        return PluginState.values()[stateOrdinal];
    }

    public void close() throws Exception {
        this.connection.close();
    }
}

