/**
 * 
 */
package org.gcube.vremanagement.executor.scheduler;

import java.util.Map;
import java.util.UUID;

import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class JobCompletedNotification implements PluginStateNotification {
	
	
	protected final Map<Integer, PluginState> executionsState;
	
	public JobCompletedNotification(Map<Integer, PluginState> executionsState){
		this.executionsState = executionsState;
	}
	
	@Override
	public void pluginStateEvolution(UUID uuid, int iteration, long timestamp,
			String pluginName, PluginState pluginState) throws Exception {
		executionsState.put(iteration, pluginState);
	}

}
