/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.configuration.jsonbased;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.configuration.jsonbased.JSONScheduling;
import org.gcube.vremanagement.executor.exception.ScopeNotMatchException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONLaunchParameter
extends LaunchParameter {
    public static final String PLUGIN_NAME = "pluginName";
    public static final String PLUGIN_CAPABILITIES = "pluginCapabilites";
    public static final String INPUTS = "inputs";
    public static final String SCHEDULING = "scheduling";
    public static final String PERSIST = "persist";
    public static final String USED_BY = "usedBy";
    public static final String SCOPE = "SCOPE";
    protected String usedBy;
    protected String scope;

    private JSONLaunchParameter() {
    }

    public JSONLaunchParameter(String pluginName, Map<String, Object> inputs) {
        super(pluginName, inputs);
    }

    public JSONLaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs) {
        super(pluginName, pluginCapabilities, inputs);
    }

    public JSONLaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling) throws ParseException {
        super(pluginName, inputs, scheduling);
    }

    public JSONLaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling) throws ParseException {
        super(pluginName, pluginCapabilities, inputs, scheduling);
    }

    public JSONLaunchParameter(String pluginName, Map<String, Object> inputs, Scheduling scheduling, boolean persist) throws ParseException {
        super(pluginName, inputs, scheduling, persist);
    }

    public JSONLaunchParameter(String pluginName, Map<String, String> pluginCapabilities, Map<String, Object> inputs, Scheduling scheduling, boolean persist) throws ParseException {
        super(pluginName, pluginCapabilities, inputs, scheduling, persist);
        this.scheduling = new JSONScheduling(scheduling);
        this.scope = ScopeProvider.instance.get();
    }

    public JSONLaunchParameter(LaunchParameter parameter) throws ParseException {
        super(parameter.getPluginName(), parameter.getPluginCapabilities(), parameter.getInputs(), parameter.getScheduling(), parameter.isPersist());
        this.scheduling = new JSONScheduling(parameter.getScheduling());
        this.scope = ScopeProvider.instance.get();
    }

    public JSONLaunchParameter(JSONObject jsonObject) throws JSONException, ParseException, ScopeNotMatchException {
        String key;
        int j;
        JSONArray names;
        this.pluginName = jsonObject.getString(PLUGIN_NAME);
        this.pluginCapabilities = null;
        if (jsonObject.has(PLUGIN_CAPABILITIES)) {
            this.pluginCapabilities = new HashMap();
            JSONObject capabilities = jsonObject.getJSONObject(PLUGIN_CAPABILITIES);
            names = capabilities.names();
            for (j = 0; j < names.length(); ++j) {
                key = names.getString(j);
                this.pluginCapabilities.put(key, capabilities.getString(key));
            }
        }
        this.inputs = new HashMap();
        JSONObject inputsJsonObject = jsonObject.getJSONObject(INPUTS);
        names = inputsJsonObject.names();
        for (j = 0; j < names.length(); ++j) {
            key = names.getString(j);
            this.inputs.put(key, inputsJsonObject.get(key));
        }
        if (jsonObject.has(SCHEDULING)) {
            JSONObject schedulingJsonObject = jsonObject.getJSONObject(SCHEDULING);
            this.scheduling = new JSONScheduling(schedulingJsonObject);
        }
        this.persist = true;
        if (jsonObject.has(PERSIST)) {
            this.persist = jsonObject.getBoolean(PERSIST);
        }
        if (jsonObject.has(USED_BY)) {
            this.usedBy = jsonObject.getString(USED_BY);
        }
        if (jsonObject.has(SCOPE)) {
            this.scope = jsonObject.getString(SCOPE);
        }
    }

    public JSONScheduling getScheduling() {
        return (JSONScheduling)this.scheduling;
    }

    public void setScheduling(JSONScheduling scheduling) {
        this.scheduling = scheduling;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(PLUGIN_NAME, (Object)this.pluginName);
        if (this.pluginCapabilities != null && !this.pluginCapabilities.isEmpty()) {
            JSONObject capabilities = new JSONObject();
            for (String id : this.pluginCapabilities.keySet()) {
                capabilities.put(id, this.pluginCapabilities.get(id));
            }
            obj.put(PLUGIN_CAPABILITIES, (Object)capabilities);
        }
        JSONObject inputJsonObject = new JSONObject();
        for (String id : this.inputs.keySet()) {
            inputJsonObject.put(id, this.inputs.get(id));
        }
        obj.put(INPUTS, (Object)inputJsonObject);
        if (this.scheduling != null) {
            obj.put(SCHEDULING, (Object)this.getScheduling().toJSON());
        }
        obj.put(PERSIST, true);
        if (this.usedBy != null) {
            obj.put(USED_BY, (Object)this.usedBy);
        }
        return obj;
    }
}

