/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduler;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.vremanagement.executor.SmartExecutorImpl;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.configuration.ScheduledTaskConfiguration;
import org.gcube.vremanagement.executor.configuration.ScheduledTaskConfigurationFactory;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorJob;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorJobListener;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.JobListener;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorScheduler {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorScheduler.class);
    protected Map<UUID, Scheduler> activeSchedulers = new HashMap();
    private static SmartExecutorScheduler smartExecutorScheduler;

    public static synchronized SmartExecutorScheduler getInstance() {
        if (smartExecutorScheduler == null) {
            smartExecutorScheduler = new SmartExecutorScheduler();
        }
        return smartExecutorScheduler;
    }

    private SmartExecutorScheduler() {
    }

    protected TriggerBuilder<? extends Trigger> createTriggerBuilder(UUID uuid, ScheduleBuilder<? extends Trigger> sb) {
        return TriggerBuilder.newTrigger().withIdentity(uuid.toString()).withSchedule(sb);
    }

    protected TriggerBuilder<? extends Trigger> getTriggerBuilderWithScheduling(UUID uuid, Scheduling scheduling) throws LaunchException {
        int times = scheduling.getSchedulingTimes();
        if (scheduling.getCronExpression() != null) {
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduling.getCronExpression());
            return this.createTriggerBuilder(uuid, (ScheduleBuilder)cronScheduleBuilder);
        }
        if (scheduling.getDelay() != null) {
            SimpleScheduleBuilder simpleScheduleBuilder = times != 0 ? SimpleScheduleBuilder.repeatSecondlyForTotalCount((int)times, (int)scheduling.getDelay()) : SimpleScheduleBuilder.repeatSecondlyForever((int)scheduling.getDelay());
            return this.createTriggerBuilder(uuid, (ScheduleBuilder)simpleScheduleBuilder);
        }
        throw new LaunchException("Invalid Scheduling");
    }

    protected Scheduler reallySchedule(UUID uuid, Scheduler scheduler, LaunchParameter parameter) throws LaunchException, InputsNullException, PluginNotFoundException {
        JobKey jobKey = new JobKey(uuid.toString());
        JobDetail jobDetail = JobBuilder.newJob(SmartExecutorJob.class).withIdentity(jobKey).build();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put("UUID", (Object)uuid);
        jobDataMap.put("LAUNCH_PARAMETER", (Object)parameter);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(uuid.toString());
        Scheduling scheduling = parameter.getScheduling();
        if (scheduling != null) {
            triggerBuilder = this.getTriggerBuilderWithScheduling(uuid, scheduling);
            if (scheduling.getFirtStartTime() != null && scheduling.getFirtStartTime() != 0L) {
                Date triggerStartTime = new Date(scheduling.getFirtStartTime());
                triggerBuilder.startAt(triggerStartTime);
            } else {
                triggerBuilder.startNow();
                scheduling.setFirstStartTime(Long.valueOf(Calendar.getInstance().getTimeInMillis()));
            }
            if (scheduling.getEndTime() != null && scheduling.getEndTime() != 0L) {
                Date triggerEndTime = new Date(scheduling.getEndTime());
                triggerBuilder.endAt(triggerEndTime);
            }
            try {
                ScheduledTaskConfiguration stc = ScheduledTaskConfigurationFactory.getLaunchConfiguration();
                String runningInstanceID = ((GCoreEndpoint)SmartExecutorImpl.getCtx().profile(GCoreEndpoint.class)).id();
                stc.addScheduledTask(uuid, runningInstanceID, parameter);
            }
            catch (Exception e) {
                logger.error("Unable to persist the scheduling", e.getCause());
            }
        } else {
            triggerBuilder.startNow();
        }
        try {
            SmartExecutorJobListener sejl = new SmartExecutorJobListener();
            scheduler.getListenerManager().addJobListener((JobListener)sejl);
            scheduler.scheduleJob(jobDetail, triggerBuilder.build());
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        return scheduler;
    }

    public synchronized UUID schedule(LaunchParameter parameter) throws LaunchException, InputsNullException, PluginNotFoundException {
        Map inputs = parameter.getInputs();
        if (inputs == null) {
            throw new RuntimeException();
        }
        UUID uuid = UUID.randomUUID();
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            this.reallySchedule(uuid, scheduler, parameter);
            this.activeSchedulers.put(uuid, scheduler);
            scheduler.start();
        }
        catch (SchedulerException e) {
            throw new LaunchException((Throwable)e);
        }
        return uuid;
    }

    public Scheduler getScheduler(UUID key) {
        return (Scheduler)this.activeSchedulers.get(key);
    }

    public synchronized void stop(UUID uuid) throws SchedulerException, SchedulePersistenceException {
        Scheduler scheduler = (Scheduler)this.activeSchedulers.get(uuid);
        if (scheduler == null) {
            throw new SchedulerNotFoundException("Scheduler Not Found");
        }
        JobKey jobKey = new JobKey(uuid.toString());
        boolean exist = scheduler.checkExists(jobKey);
        if (!exist) {
            logger.trace("Job {} does not exist. Terminating the stop method", (Object)uuid);
            return;
        }
        logger.trace("Job {} exist", (Object)uuid);
        logger.trace("Getting {} list", (Object)JobExecutionContext.class.getSimpleName());
        List cej = scheduler.getCurrentlyExecutingJobs();
        while (cej.isEmpty()) {
            cej = scheduler.getCurrentlyExecutingJobs();
        }
        logger.trace("{} list got", (Object)JobExecutionContext.class.getSimpleName());
        boolean interrupted = scheduler.interrupt(jobKey);
        if (interrupted) {
            logger.debug("Job {} interrupted successfully. Going to delete it.", (Object)uuid);
        } else {
            logger.debug("Job {} was not interrupted, going to delete it", (Object)uuid);
        }
        boolean deleted = scheduler.deleteJob(jobKey);
        if (deleted) {
            logger.debug("Job {} deleted successfully", (Object)uuid);
        } else {
            logger.debug("Job {} was not deleted", (Object)uuid);
        }
        this.activeSchedulers.remove(uuid);
        scheduler.clear();
        boolean remove = true;
        try {
            ScheduledTaskConfiguration stc = ScheduledTaskConfigurationFactory.getLaunchConfiguration();
            if (remove) {
                stc.removeScheduledTask(uuid);
            } else {
                stc.releaseScheduledTask(uuid);
            }
        }
        catch (Exception e) {
            throw new SchedulePersistenceException(e.getCause());
        }
    }

    public void stopAll() {
        ArrayList set = new ArrayList(this.activeSchedulers.keySet());
        for (UUID uuid : set) {
            try {
                this.stop(uuid);
            }
            catch (Exception e) {
                logger.error("Error stopping plugin instace with UUID {}", (Object)uuid, (Object)e);
            }
        }
    }
}

