/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.persistence.couchdb;

import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.smartgears.ContextProvider;
import org.gcube.vremanagement.executor.SmartExecutorInitializator;
import org.gcube.vremanagement.executor.exception.InvalidPluginStateEvolutionException;
import org.gcube.vremanagement.executor.persistence.couchdb.PluginStateEvolutionObjectNode;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginStateEvolutionObjectNode {
    protected static final String EVOLUTION_TYPE = "evolution";
    public static final String UUID_FIELD = "uuid";
    public static final String ITERATION_FIELD = "iteration";
    public static final String PLUGIN_DECLARATION_FIELD = "pluginDeclaration";
    public static final String PLUGIN_DECLARATION_NAME_FIELD = "name";
    public static final String PLUGIN_DECLARATION_DESCRIPTION_FIELD = "description";
    public static final String PLUGIN_DECLARATION_VERSION_FIELD = "version";
    public static final String PLUGIN_DECLARATION_HOST_DISCOVERED_CAPABILITIES_FIELD = "hostDiscoveredCapabilities";
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String STATE_FIELD = "state";
    protected static final String RUN_ON_FIELD = "runOn";
    public static final String GHN_HOSTNAME_FIELD = "ghnHostname";
    public static final String GHN_ID_FIELD = "ghnID";
    public static final String SCOPE_FIELD = "scope";
    public static final String LOCALHOST = "localhost";
    public static final String PERCENTAGE = "percentage";

    protected static ObjectNode getRunOn() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        try {
            GCoreEndpoint gCoreEndpoint = (GCoreEndpoint)ContextProvider.get().profile(GCoreEndpoint.class);
            objectNode.put("ghnID", gCoreEndpoint.profile().ghnId());
            objectNode.put("ghnHostname", ContextProvider.get().container().configuration().hostname());
        }
        catch (Exception e) {
            objectNode.put("ghnID", "localhost_" + UUID.randomUUID());
            objectNode.put("ghnHostname", "localhost");
        }
        return objectNode;
    }

    protected static ObjectNode getPluginInfo(PluginDeclaration pluginDeclaration) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("name", pluginDeclaration.getName());
        objectNode.put("description", pluginDeclaration.getDescription());
        objectNode.put("version", pluginDeclaration.getVersion());
        Map capabilites = pluginDeclaration.getSupportedCapabilities();
        ObjectNode capabilitiesObjectNode = objectMapper.createObjectNode();
        if (capabilites != null) {
            for (String key : capabilites.keySet()) {
                capabilitiesObjectNode.put(key, (String)capabilites.get(key));
            }
        }
        objectNode.put("hostDiscoveredCapabilities", (JsonNode)capabilitiesObjectNode);
        return objectNode;
    }

    protected static PluginDeclaration getPluginDeclaration(JsonNode jsonNode) {
        1 pluginDeclaration = new /* Unavailable Anonymous Inner Class!! */;
        return pluginDeclaration;
    }

    public static void addScope(ObjectNode objectNode) {
        objectNode.put("scope", SmartExecutorInitializator.getScopeFromToken());
    }

    public static ObjectNode getObjectMapper(PluginStateEvolution pluginStateEvolution) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("uuid", pluginStateEvolution.getUuid().toString());
        objectNode.put("iteration", pluginStateEvolution.getIteration());
        objectNode.put("timestamp", pluginStateEvolution.getTimestamp());
        objectNode.put("pluginDeclaration", (JsonNode)PluginStateEvolutionObjectNode.getPluginInfo((PluginDeclaration)pluginStateEvolution.getPluginDeclaration()));
        objectNode.put("state", pluginStateEvolution.getPluginState().toString());
        objectNode.put("percentage", pluginStateEvolution.getPercentage());
        PluginStateEvolutionObjectNode.addScope((ObjectNode)objectNode);
        objectNode.put("type", "evolution");
        try {
            objectNode.put("runOn", (JsonNode)PluginStateEvolutionObjectNode.getRunOn());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectNode;
    }

    public static PluginStateEvolution getPluginStateEvolution(JsonNode jsonNode) throws InvalidPluginStateEvolutionException {
        UUID uuid = UUID.fromString(jsonNode.get("uuid").asText());
        int iteration = jsonNode.get("iteration").asInt();
        long timestamp = jsonNode.get("timestamp").asInt();
        PluginDeclaration pluginDeclaration = PluginStateEvolutionObjectNode.getPluginDeclaration((JsonNode)jsonNode.get("pluginDeclaration"));
        PluginState pluginState = PluginState.valueOf((String)jsonNode.get("state").asText());
        int percentage = jsonNode.get("percentage").asInt();
        return new PluginStateEvolution(uuid, iteration, timestamp, pluginDeclaration, pluginState, Integer.valueOf(percentage));
    }
}

